/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;

public class MapScanCodec
implements Codec {
    private final Codec delegate;
    private final Codec mapValueCodec;

    public MapScanCodec(Codec delegate) {
        this(delegate, null);
    }

    public MapScanCodec(Codec delegate, Codec mapValueCodec) {
        this.delegate = delegate;
        this.mapValueCodec = mapValueCodec;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.delegate.getValueDecoder();
    }

    @Override
    public Encoder getValueEncoder() {
        return this.delegate.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                buf.markReaderIndex();
                long[] hash = Hash.hash128(buf);
                buf.resetReaderIndex();
                Codec c = MapScanCodec.this.delegate;
                if (MapScanCodec.this.mapValueCodec != null) {
                    c = MapScanCodec.this.mapValueCodec;
                }
                Object val = c.getMapValueDecoder().decode(buf, state);
                return new ScanObjectEntry(new HashValue(hash), val);
            }
        };
    }

    @Override
    public Encoder getMapValueEncoder() {
        Codec c = this.delegate;
        if (this.mapValueCodec != null) {
            c = this.mapValueCodec;
        }
        return c.getMapValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                buf.markReaderIndex();
                long[] hash = Hash.hash128(buf);
                buf.resetReaderIndex();
                Object val = MapScanCodec.this.delegate.getMapKeyDecoder().decode(buf, state);
                return new ScanObjectEntry(new HashValue(hash), val);
            }
        };
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.delegate.getMapKeyEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

