/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.renewal.LockEntry;

public class ReadLockEntry
extends LockEntry {
    private final Map<Long, String> threadId2keyPrefix = new ConcurrentHashMap<Long, String>();

    public String getKeyPrefix(Long threadId) {
        return this.threadId2keyPrefix.get(threadId);
    }

    public void addThreadId(long threadId, String lockName, String keyPrefix) {
        this.threadId2counter.compute(threadId, (t, counter) -> {
            Integer n = counter = Optional.ofNullable(counter).orElse(0);
            counter = counter + 1;
            this.threadsQueue.add(threadId);
            return counter;
        });
        this.threadId2lockName.putIfAbsent(threadId, lockName);
        this.threadId2keyPrefix.putIfAbsent(threadId, keyPrefix);
    }

    @Override
    public void removeThreadId(long threadId) {
        this.threadId2counter.computeIfPresent(threadId, (t, counter) -> {
            Integer n = counter;
            counter = counter - 1;
            if (counter == 0) {
                this.threadsQueue.remove(threadId);
                this.threadId2lockName.remove(threadId);
                this.threadId2keyPrefix.remove(threadId);
                return null;
            }
            return counter;
        });
    }
}

