/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RFuture;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.Tuple;

public class ProxyBuilder {
    private static final ConcurrentMap<Tuple<Method, Class<?>>, Method> METHODS_MAPPING = new ConcurrentHashMap();

    public static <T> T create(final Callback commandExecutor, final Object instance, final Object implementation, Class<T> clazz, ServiceManager serviceManager) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method instanceMethod = ProxyBuilder.getMethod(method, instance, implementation);
                if (instanceMethod.getName().endsWith("Async")) {
                    Callable<RFuture<Object>> callable = () -> (RFuture)instanceMethod.invoke(instance, args);
                    return commandExecutor.execute(callable, method);
                }
                if (implementation != null && instanceMethod.getDeclaringClass().isAssignableFrom(implementation.getClass())) {
                    return instanceMethod.invoke(implementation, args);
                }
                return instanceMethod.invoke(instance, args);
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    private static Method getMethod(Method method, Object instance, Object implementation) throws NoSuchMethodException {
        Tuple key = new Tuple(method, instance.getClass());
        Method instanceMethod = (Method)METHODS_MAPPING.get(key);
        if (instanceMethod == null) {
            if (implementation != null) {
                try {
                    instanceMethod = implementation.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    try {
                        instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                    }
                    catch (Exception e2) {
                        instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                    }
                }
            } else {
                try {
                    instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
            }
            METHODS_MAPPING.put(key, instanceMethod);
        }
        return instanceMethod;
    }

    public static interface Callback {
        public Object execute(Callable<RFuture<Object>> var1, Method var2);
    }
}

