/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.stream;

import java.util.Map;
import org.redisson.api.StreamMessageId;
import org.redisson.api.stream.RefPolicy;
import org.redisson.api.stream.StreamAddArgs;
import org.redisson.api.stream.StreamTrimLimitArgs;
import org.redisson.api.stream.StreamTrimReferencesArgs;
import org.redisson.api.stream.StreamTrimStrategyArgs;

public final class StreamAddParams<K, V>
implements StreamAddArgs<K, V>,
StreamTrimStrategyArgs<StreamAddArgs<K, V>>,
StreamTrimReferencesArgs<StreamAddArgs<K, V>> {
    private final Map<K, V> entries;
    private boolean noMakeStream;
    private boolean trimStrict;
    private int maxLen;
    private StreamMessageId minId;
    private int limit;
    private RefPolicy refPolicy;

    StreamAddParams(Map<K, V> entries) {
        this.entries = entries;
    }

    @Override
    public StreamAddArgs<K, V> noMakeStream() {
        this.noMakeStream = true;
        return this;
    }

    @Override
    public StreamTrimStrategyArgs<StreamAddArgs<K, V>> trim() {
        this.trimStrict = true;
        return this;
    }

    @Override
    public StreamTrimStrategyArgs<StreamAddArgs<K, V>> trimNonStrict() {
        this.trimStrict = false;
        return this;
    }

    @Override
    public StreamTrimReferencesArgs<StreamAddArgs<K, V>> maxLen(int threshold) {
        this.maxLen = threshold;
        return this;
    }

    @Override
    public StreamTrimReferencesArgs<StreamAddArgs<K, V>> minId(StreamMessageId messageId) {
        this.minId = messageId;
        return this;
    }

    @Override
    public StreamAddArgs<K, V> noLimit() {
        this.limit = 0;
        return this;
    }

    @Override
    public StreamAddArgs<K, V> limit(int size) {
        this.limit = size;
        return this;
    }

    public Map<K, V> getEntries() {
        return this.entries;
    }

    public boolean isNoMakeStream() {
        return this.noMakeStream;
    }

    public boolean isTrimStrict() {
        return this.trimStrict;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public StreamMessageId getMinId() {
        return this.minId;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public StreamTrimLimitArgs<StreamAddArgs<K, V>> removeReferences() {
        this.refPolicy = RefPolicy.DELREF;
        return this;
    }

    @Override
    public StreamTrimLimitArgs<StreamAddArgs<K, V>> keepReferences() {
        this.refPolicy = RefPolicy.KEEPREF;
        return this;
    }

    @Override
    public StreamTrimLimitArgs<StreamAddArgs<K, V>> removeAcknowledgedOnly() {
        this.refPolicy = RefPolicy.DELREF;
        return this;
    }

    public RefPolicy getRefPolicy() {
        return this.refPolicy;
    }
}

