/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.redisson.config.ConstantDelay;
import org.redisson.config.DelayStrategy;

public final class BatchOptions {
    private ExecutionMode executionMode = ExecutionMode.IN_MEMORY;
    private long responseTimeout;
    private int retryAttempts = -1;
    private DelayStrategy retryDelay;
    private long syncTimeout;
    private int syncSlaves;
    private int syncLocals;
    private boolean syncAOF;
    private boolean skipResult;

    private BatchOptions() {
    }

    public static BatchOptions defaults() {
        return new BatchOptions();
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public BatchOptions responseTimeout(long timeout, TimeUnit unit) {
        this.responseTimeout = unit.toMillis(timeout);
        return this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public BatchOptions retryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return this;
    }

    @Deprecated
    public BatchOptions retryInterval(long retryInterval, TimeUnit retryIntervalUnit) {
        this.retryDelay = new ConstantDelay(Duration.ofMillis(retryIntervalUnit.toMillis(retryInterval)));
        return this;
    }

    @Deprecated
    public BatchOptions syncSlaves(int slaves, long timeout, TimeUnit unit) {
        this.syncSlaves = slaves;
        this.syncTimeout = unit.toMillis(timeout);
        return this;
    }

    public BatchOptions sync(int slaves, Duration timeout) {
        this.syncSlaves = slaves;
        this.syncTimeout = timeout.toMillis();
        return this;
    }

    public long getSyncTimeout() {
        return this.syncTimeout;
    }

    public int getSyncSlaves() {
        return this.syncSlaves;
    }

    public BatchOptions skipResult() {
        this.skipResult = true;
        return this;
    }

    public BatchOptions syncAOF(int localNum, int slaves, Duration timeout) {
        this.syncSlaves = slaves;
        this.syncAOF = true;
        this.syncLocals = localNum;
        this.syncTimeout = timeout.toMillis();
        return this;
    }

    public boolean isSkipResult() {
        return this.skipResult;
    }

    public int getSyncLocals() {
        return this.syncLocals;
    }

    public boolean isSyncAOF() {
        return this.syncAOF;
    }

    public BatchOptions executionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
        return this;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public String toString() {
        return "BatchOptions [queueStore=" + (Object)((Object)this.executionMode) + "]";
    }

    public DelayStrategy getRetryDelay() {
        return this.retryDelay;
    }

    public BatchOptions retryDelay(DelayStrategy retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public static enum ExecutionMode {
        REDIS_READ_ATOMIC,
        REDIS_WRITE_ATOMIC,
        IN_MEMORY,
        IN_MEMORY_ATOMIC;

    }
}

