/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractBackpressureThrottlingSubscriber<T, R>
extends AtomicInteger
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = -5050301752721603566L;
    final Subscriber<? super R> downstream;
    Subscription upstream;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<R> current = new AtomicReference();

    AbstractBackpressureThrottlingSubscriber(Subscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.upstream, s)) {
            this.upstream = s;
            this.downstream.onSubscribe(this);
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public abstract void onNext(T var1);

    @Override
    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            BackpressureHelper.add(this.requested, n);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.current.lazySet(null);
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Subscriber<R> a = this.downstream;
        int missed = 1;
        AtomicLong r = this.requested;
        AtomicReference<R> q = this.current;
        do {
            long e;
            for (e = 0L; e != r.get(); ++e) {
                boolean empty;
                boolean d = this.done;
                Object v = q.getAndSet(null);
                boolean bl = empty = v == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (empty) break;
                a.onNext(v);
            }
            if (e == r.get() && this.checkTerminated(this.done, q.get() == null, a, q)) {
                return;
            }
            if (e == 0L) continue;
            BackpressureHelper.produced(r, e);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, AtomicReference<R> q) {
        if (this.cancelled) {
            q.lazySet(null);
            return true;
        }
        if (d) {
            Throwable e = this.error;
            if (e != null) {
                q.lazySet(null);
                a.onError(e);
                return true;
            }
            if (empty) {
                a.onComplete();
                return true;
            }
        }
        return false;
    }
}

