/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.util.BitSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.misc.RedisURI;

public class ClusterPartition {
    private Type type = Type.MASTER;
    private final String nodeId;
    private boolean masterFail;
    private RedisURI masterAddress;
    private final Set<RedisURI> slaveAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<RedisURI> failedSlaves = Collections.newSetFromMap(new ConcurrentHashMap());
    private BitSet slots;
    private Set<ClusterSlotRange> slotRanges = Collections.emptySet();
    private ClusterPartition parent;
    private int references;
    private long time = System.currentTimeMillis();

    public ClusterPartition(String nodeId) {
        this.nodeId = nodeId;
    }

    public ClusterPartition getParent() {
        return this.parent;
    }

    public void setParent(ClusterPartition parent) {
        this.parent = parent;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setMasterFail(boolean masterFail) {
        this.masterFail = masterFail;
    }

    public boolean isMasterFail() {
        return this.masterFail;
    }

    public void updateSlotRanges(Set<ClusterSlotRange> ranges, BitSet slots) {
        this.slotRanges = ranges;
        this.slots = slots;
    }

    public void setSlotRanges(Set<ClusterSlotRange> ranges) {
        this.slots = new BitSet(16384);
        for (ClusterSlotRange clusterSlotRange : ranges) {
            this.slots.set(clusterSlotRange.getStartSlot(), clusterSlotRange.getEndSlot() + 1);
        }
        this.slotRanges = ranges;
    }

    public Set<ClusterSlotRange> getSlotRanges() {
        return Collections.unmodifiableSet(this.slotRanges);
    }

    public Iterable<Integer> getSlots() {
        return this.slots.stream()::iterator;
    }

    public BitSet slots() {
        return this.slots;
    }

    public BitSet copySlots() {
        return (BitSet)this.slots.clone();
    }

    public boolean hasSlot(int slot) {
        return this.slots.get(slot);
    }

    public int getSlotsAmount() {
        return this.slots.cardinality();
    }

    public RedisURI getMasterAddress() {
        return this.masterAddress;
    }

    public void setMasterAddress(RedisURI masterAddress) {
        this.masterAddress = masterAddress;
    }

    public void addFailedSlaveAddress(RedisURI address) {
        this.failedSlaves.add(address);
    }

    public Set<RedisURI> getFailedSlaveAddresses() {
        return Collections.unmodifiableSet(this.failedSlaves);
    }

    public void removeFailedSlaveAddress(RedisURI uri) {
        this.failedSlaves.remove(uri);
    }

    public void addSlaveAddress(RedisURI address) {
        this.slaveAddresses.add(address);
    }

    public Set<RedisURI> getSlaveAddresses() {
        return Collections.unmodifiableSet(this.slaveAddresses);
    }

    public void removeSlaveAddress(RedisURI uri) {
        this.slaveAddresses.remove(uri);
        this.failedSlaves.remove(uri);
    }

    public void incReference() {
        ++this.references;
    }

    public int decReference() {
        return --this.references;
    }

    public long getTime() {
        return this.time;
    }

    public int hashCode() {
        return Objects.hash(this.nodeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPartition that = (ClusterPartition)o;
        return Objects.equals(this.nodeId, that.nodeId);
    }

    public String toString() {
        return "ClusterPartition [nodeId=" + this.nodeId + ", masterFail=" + this.masterFail + ", masterAddress=" + this.masterAddress + ", slaveAddresses=" + this.slaveAddresses + ", failedSlaves=" + this.failedSlaves + ", slotRanges=" + this.slotRanges + "]";
    }

    public static enum Type {
        MASTER,
        SLAVE;

    }
}

