/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.redisson.api.vector.QuantizationType;
import org.redisson.api.vector.VectorInfo;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class VectorInfoDecoder
implements MultiDecoder<VectorInfo> {
    @Override
    public VectorInfo decode(List<Object> parts, State state) {
        Map<String, Object> map = IntStream.range(0, parts.size()).filter(i -> i % 2 == 0).mapToObj(i -> parts.subList(i, i + 2)).filter(p -> p.get(1) != null).collect(Collectors.toMap(e -> (String)e.get(0), e -> e.get(1)));
        VectorInfo info = new VectorInfo();
        info.setDimensions((Long)map.get("vector-dim"));
        info.setAttributesCount((Long)map.get("attributes-count"));
        info.setMaxConnections(((Long)map.get("hnsw-m")).intValue());
        String qt = (String)map.get("quant-type");
        if ("int8".equals(qt)) {
            info.setQuantizationType(QuantizationType.Q8);
        } else if ("bin".equals(qt)) {
            info.setQuantizationType(QuantizationType.BIN);
        } else if ("f32".equals(qt)) {
            info.setQuantizationType(QuantizationType.NOQUANT);
        }
        info.setSize((Long)map.get("size"));
        return info;
    }
}

