/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.scheduler.ExecutorServiceWorker;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

final class ParallelScheduler
implements Scheduler,
Supplier<ScheduledExecutorService> {
    static final AtomicLong COUNTER = new AtomicLong();
    final int n;
    final ThreadFactory factory;
    volatile ScheduledExecutorService[] executors;
    static final AtomicReferenceFieldUpdater<ParallelScheduler, ScheduledExecutorService[]> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(ParallelScheduler.class, ScheduledExecutorService[].class, "executors");
    static final ScheduledExecutorService[] SHUTDOWN = new ScheduledExecutorService[0];
    static final ScheduledExecutorService TERMINATED = Executors.newSingleThreadScheduledExecutor();
    int roundRobin;

    ParallelScheduler(int n, ThreadFactory factory) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.n = n;
        this.factory = factory;
        this.init(n);
    }

    @Override
    public ScheduledExecutorService get() {
        return Executors.newSingleThreadScheduledExecutor(this.factory);
    }

    void init(int n) {
        ScheduledExecutorService[] a = new ScheduledExecutorService[n];
        for (int i = 0; i < n; ++i) {
            a[i] = Schedulers.decorateExecutorService("parallel", this);
        }
        EXECUTORS.lazySet(this, a);
    }

    @Override
    public boolean isDisposed() {
        return this.executors == SHUTDOWN;
    }

    @Override
    public void start() {
        ScheduledExecutorService[] a;
        ScheduledExecutorService[] b = null;
        do {
            if ((a = this.executors) != SHUTDOWN) {
                if (b != null) {
                    for (ScheduledExecutorService exec : b) {
                        exec.shutdownNow();
                    }
                }
                return;
            }
            if (b != null) continue;
            b = new ScheduledExecutorService[this.n];
            for (int i = 0; i < this.n; ++i) {
                b[i] = Schedulers.decorateExecutorService("parallel", this);
            }
        } while (!EXECUTORS.compareAndSet(this, a, b));
    }

    @Override
    public void dispose() {
        ScheduledExecutorService[] a = this.executors;
        if (a != SHUTDOWN && (a = EXECUTORS.getAndSet(this, SHUTDOWN)) != SHUTDOWN) {
            for (ScheduledExecutorService exec : a) {
                exec.shutdownNow();
            }
        }
    }

    ScheduledExecutorService pick() {
        ScheduledExecutorService[] a = this.executors;
        if (a != SHUTDOWN) {
            int idx = this.roundRobin;
            if (idx == this.n) {
                idx = 0;
                this.roundRobin = 1;
            } else {
                this.roundRobin = idx + 1;
            }
            return a[idx];
        }
        return TERMINATED;
    }

    @Override
    public Disposable schedule(Runnable task) {
        return Schedulers.directSchedule(this.pick(), task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return Schedulers.directSchedule(this.pick(), task, delay, unit);
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return Schedulers.directSchedulePeriodically(this.pick(), task, initialDelay, period, unit);
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorServiceWorker(this.pick());
    }

    static {
        TERMINATED.shutdownNow();
    }
}

