/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.OperatorDisposables;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxRefCount<T>
extends Flux<T>
implements Scannable,
Fuseable {
    final ConnectableFlux<? extends T> source;
    final int n;
    volatile RefCountMonitor<T> connection;
    static final AtomicReferenceFieldUpdater<FluxRefCount, RefCountMonitor> CONNECTION = AtomicReferenceFieldUpdater.newUpdater(FluxRefCount.class, RefCountMonitor.class, "connection");

    FluxRefCount(ConnectableFlux<? extends T> source, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.n = n;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        RefCountMonitor<? super T> state;
        while ((state = this.connection) == null || OperatorDisposables.isDisposed(state.disconnect)) {
            RefCountMonitor u = new RefCountMonitor(this.n, this);
            if (!CONNECTION.compareAndSet(this, state, u)) continue;
            state = u;
            break;
        }
        state.subscribe(actual);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    static final class RefCountInner<T>
    implements Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final RefCountMonitor<T> parent;
        Subscription s;
        Fuseable.QueueSubscription<T> qs;

        RefCountInner(CoreSubscriber<? super T> actual, RefCountMonitor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
            this.parent.upstreamFinished();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
            this.parent.upstreamFinished();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
            this.parent.innerCancelled();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if (this.s instanceof Fuseable.QueueSubscription) {
                this.qs = (Fuseable.QueueSubscription)this.s;
                return this.qs.requestFusion(requestedMode);
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            return (T)this.qs.poll();
        }

        @Override
        public int size() {
            return this.qs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
        }
    }

    static final class RefCountMonitor<T>
    implements Consumer<Disposable> {
        final int n;
        final FluxRefCount<? extends T> parent;
        volatile int subscribers;
        static final AtomicIntegerFieldUpdater<RefCountMonitor> SUBSCRIBERS = AtomicIntegerFieldUpdater.newUpdater(RefCountMonitor.class, "subscribers");
        volatile Disposable disconnect;
        static final AtomicReferenceFieldUpdater<RefCountMonitor, Disposable> DISCONNECT = AtomicReferenceFieldUpdater.newUpdater(RefCountMonitor.class, Disposable.class, "disconnect");

        RefCountMonitor(int n, FluxRefCount<? extends T> parent) {
            this.n = n;
            this.parent = parent;
        }

        void subscribe(CoreSubscriber<? super T> s) {
            RefCountInner<? super T> inner = new RefCountInner<T>(s, this);
            this.parent.source.subscribe((CoreSubscriber<? super T>)inner);
            if (SUBSCRIBERS.incrementAndGet(this) == this.n) {
                this.parent.source.connect(this);
            }
        }

        @Override
        public void accept(Disposable r) {
            if (!DISCONNECT.compareAndSet(this, null, r)) {
                r.dispose();
            }
        }

        void innerCancelled() {
            if (SUBSCRIBERS.decrementAndGet(this) == 0) {
                OperatorDisposables.dispose(DISCONNECT, this);
            }
        }

        void upstreamFinished() {
            Disposable a = this.disconnect;
            if (a != OperatorDisposables.DISPOSED) {
                DISCONNECT.getAndSet(this, OperatorDisposables.DISPOSED);
            }
        }
    }
}

