/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSMonitor {
    private static final Logger log = LoggerFactory.getLogger(DNSMonitor.class);
    private DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(NioDatagramChannel.class, (DnsServerAddressStreamProvider)DefaultDnsServerAddressStreamProvider.INSTANCE);
    private ScheduledFuture<?> dnsMonitorFuture;
    private ConnectionManager connectionManager;
    private final Map<URI, InetAddress> masters = new HashMap<URI, InetAddress>();
    private final Map<URI, InetAddress> slaves = new HashMap<URI, InetAddress>();
    private long dnsMonitoringInterval;

    public DNSMonitor(ConnectionManager connectionManager, Set<URI> masterHosts, Set<URI> slaveHosts, long dnsMonitoringInterval) {
        Future resolveFuture;
        AddressResolver resolver = this.resolverGroup.getResolver(connectionManager.getGroup().next());
        for (URI host : masterHosts) {
            resolveFuture = resolver.resolve(InetSocketAddress.createUnresolved(host.getHost(), 0));
            resolveFuture.syncUninterruptibly();
            this.masters.put(host, ((InetSocketAddress)resolveFuture.getNow()).getAddress());
        }
        for (URI host : slaveHosts) {
            resolveFuture = resolver.resolve(InetSocketAddress.createUnresolved(host.getHost(), 0));
            resolveFuture.syncUninterruptibly();
            this.slaves.put(host, ((InetSocketAddress)resolveFuture.getNow()).getAddress());
        }
        this.connectionManager = connectionManager;
        this.dnsMonitoringInterval = dnsMonitoringInterval;
    }

    public void start() {
        this.monitorDnsChange();
        log.debug("DNS monitoring enabled; Current masters: {}, slaves: {}", (Object)this.masters, (Object)this.slaves);
    }

    public void stop() {
        if (this.dnsMonitorFuture != null) {
            this.dnsMonitorFuture.cancel(true);
        }
    }

    private void monitorDnsChange() {
        this.dnsMonitorFuture = this.connectionManager.getGroup().schedule(new Runnable(){

            @Override
            public void run() {
                Future resolveFuture;
                AddressResolver resolver = DNSMonitor.this.resolverGroup.getResolver(DNSMonitor.this.connectionManager.getGroup().next());
                final AtomicInteger counter = new AtomicInteger(DNSMonitor.this.masters.size() + DNSMonitor.this.slaves.size());
                for (final Map.Entry entry : DNSMonitor.this.masters.entrySet()) {
                    resolveFuture = resolver.resolve(InetSocketAddress.createUnresolved(((URI)entry.getKey()).getHost(), 0));
                    resolveFuture.addListener(new FutureListener<InetSocketAddress>(){

                        @Override
                        public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                            if (counter.decrementAndGet() == 0) {
                                DNSMonitor.this.monitorDnsChange();
                            }
                            if (!future.isSuccess()) {
                                log.error("Unable to resolve " + ((URI)entry.getKey()).getHost(), future.cause());
                                return;
                            }
                            InetAddress master = (InetAddress)entry.getValue();
                            InetAddress now = ((InetSocketAddress)future.get()).getAddress();
                            if (!now.getHostAddress().equals(master.getHostAddress())) {
                                log.info("Detected DNS change. {} has changed from {} to {}", ((URI)entry.getKey()).getHost(), master.getHostAddress(), now.getHostAddress());
                                for (MasterSlaveEntry entrySet : DNSMonitor.this.connectionManager.getEntrySet()) {
                                    if (!entrySet.getClient().getAddr().getHostName().equals(((URI)entry.getKey()).getHost()) || entrySet.getClient().getAddr().getPort() != ((URI)entry.getKey()).getPort()) continue;
                                    entrySet.changeMaster((URI)entry.getKey());
                                }
                                DNSMonitor.this.masters.put(entry.getKey(), now);
                                log.info("Master {} has been changed", (Object)((URI)entry.getKey()).getHost());
                            }
                        }
                    });
                }
                for (final Map.Entry entry : DNSMonitor.this.slaves.entrySet()) {
                    resolveFuture = resolver.resolve(InetSocketAddress.createUnresolved(((URI)entry.getKey()).getHost(), 0));
                    resolveFuture.addListener(new FutureListener<InetSocketAddress>(){

                        @Override
                        public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                            if (counter.decrementAndGet() == 0) {
                                DNSMonitor.this.monitorDnsChange();
                            }
                            if (!future.isSuccess()) {
                                log.error("Unable to resolve " + ((URI)entry.getKey()).getHost(), future.cause());
                                return;
                            }
                            InetAddress slave = (InetAddress)entry.getValue();
                            InetAddress updatedSlave = ((InetSocketAddress)future.get()).getAddress();
                            if (!updatedSlave.getHostAddress().equals(slave.getHostAddress())) {
                                log.info("Detected DNS change. {} has changed from {} to {}", ((URI)entry.getKey()).getHost(), slave.getHostAddress(), updatedSlave.getHostAddress());
                                for (MasterSlaveEntry masterSlaveEntry : DNSMonitor.this.connectionManager.getEntrySet()) {
                                    URI uri;
                                    if (!masterSlaveEntry.slaveDown(uri = URIBuilder.create(slave.getHostAddress() + ":" + ((URI)entry.getKey()).getPort()), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
                                    masterSlaveEntry.slaveUp((URI)entry.getKey(), ClientConnectionsEntry.FreezeReason.MANAGER);
                                }
                                DNSMonitor.this.slaves.put(entry.getKey(), updatedSlave);
                                log.info("Slave {} has been changed", (Object)((URI)entry.getKey()).getHost());
                            }
                        }
                    });
                }
            }
        }, this.dnsMonitoringInterval, TimeUnit.MILLISECONDS);
    }
}

