/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonReference;
import org.redisson.RedissonShutdownException;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.AsyncDetails;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonObjectFactory;
import org.redisson.misc.RedissonPromise;

public class CommandBatchService
extends CommandAsyncService {
    private final AtomicInteger index = new AtomicInteger();
    private ConcurrentMap<MasterSlaveEntry, Entry> commands = PlatformDependent.newConcurrentHashMap();
    private volatile boolean executed;

    public CommandBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt) {
        if (this.executed) {
            throw new IllegalStateException("Batch already has been executed!");
        }
        Entry entry = (Entry)this.commands.get(nodeSource.getEntry());
        if (entry == null) {
            entry = new Entry();
            Entry oldEntry = this.commands.putIfAbsent(nodeSource.getEntry(), entry);
            if (oldEntry != null) {
                entry = oldEntry;
            }
        }
        if (!readOnlyMode) {
            entry.setReadOnlyMode(false);
        }
        if (this.isRedissonReferenceSupportEnabled()) {
            for (int i = 0; i < params.length; ++i) {
                RedissonReference reference = RedissonObjectFactory.toReference(this.connectionManager.getCfg(), params[i]);
                if (reference == null) continue;
                params[i] = reference;
            }
        }
        BatchCommandData<V, R> commandData = new BatchCommandData<V, R>(mainPromise, codec, command, params, this.index.incrementAndGet());
        entry.getCommands().add(commandData);
    }

    public BatchResult<?> execute() {
        RFuture f = this.executeAsync(0, 0L, false, 0L, 0, 0L);
        return (BatchResult)this.get(f);
    }

    public BatchResult<?> execute(int syncSlaves, long syncTimeout, boolean noResult, long responseTimeout, int retryAttempts, long retryInterval) {
        RFuture f = this.executeAsync(syncSlaves, syncTimeout, noResult, responseTimeout, retryAttempts, retryInterval);
        return (BatchResult)this.get(f);
    }

    public RFuture<Void> executeAsyncVoid() {
        final RedissonPromise<Void> promise = new RedissonPromise<Void>();
        RFuture res = this.executeAsync(0, 0L, false, 0L, 0, 0L);
        res.addListener(new FutureListener<BatchResult<?>>(){

            @Override
            public void operationComplete(Future<BatchResult<?>> future) throws Exception {
                if (future.isSuccess()) {
                    promise.trySuccess(null);
                } else {
                    promise.tryFailure(future.cause());
                }
            }
        });
        return promise;
    }

    public RFuture<List<?>> executeAsync() {
        return this.executeAsync(0, 0L, false, 0L, 0, 0L);
    }

    public <R> RFuture<R> executeAsync(int syncSlaves, long syncTimeout, boolean skipResult, long responseTimeout, int retryAttempts, long retryInterval) {
        RedissonPromise<Void> resultPromise;
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        this.executed = true;
        if (skipResult) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData offCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                entry.getCommands().addFirst(offCommand);
                BatchCommandData onCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                entry.getCommands().add(onCommand);
            }
        }
        if (syncSlaves > 0) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{syncSlaves, syncTimeout}, this.index.incrementAndGet());
                entry.getCommands().add(waitCommand);
            }
        }
        RedissonPromise<Void> voidPromise = new RedissonPromise<Void>();
        if (skipResult) {
            voidPromise.addListener((FutureListener)new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    CommandBatchService.this.commands = null;
                }
            });
            resultPromise = voidPromise;
        } else {
            final RedissonPromise promise = new RedissonPromise();
            voidPromise.addListener((FutureListener)new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        promise.tryFailure(future.cause());
                        CommandBatchService.this.commands = null;
                        return;
                    }
                    ArrayList entries = new ArrayList();
                    for (Entry e : CommandBatchService.this.commands.values()) {
                        entries.addAll(e.getCommands());
                    }
                    Collections.sort(entries);
                    ArrayList responses = new ArrayList(entries.size());
                    int syncedSlaves = 0;
                    for (BatchCommandData batchCommandData : entries) {
                        if (!CommandBatchService.this.isWaitCommand(batchCommandData)) {
                            Object entryResult = batchCommandData.getPromise().getNow();
                            entryResult = CommandBatchService.this.tryHandleReference(entryResult);
                            responses.add(entryResult);
                            continue;
                        }
                        syncedSlaves = (Integer)batchCommandData.getPromise().getNow();
                    }
                    BatchResult result = new BatchResult(responses, syncedSlaves);
                    promise.trySuccess(result);
                    CommandBatchService.this.commands = null;
                }
            });
            resultPromise = promise;
        }
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), new NodeSource((MasterSlaveEntry)e.getKey()), voidPromise, slots, 0, skipResult, responseTimeout, retryAttempts, retryInterval);
        }
        return resultPromise;
    }

    private void execute(final Entry entry, final NodeSource source, final RPromise<Void> mainPromise, final AtomicInteger slots, final int attempt, final boolean noResult, final long responseTimeout, final int retryAttempts, final long retryInterval) {
        if (mainPromise.isCancelled()) {
            this.free(entry);
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            this.free(entry);
            mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        final RedissonPromise attemptPromise = new RedissonPromise();
        final AsyncDetails details = new AsyncDetails();
        final RFuture<RedisConnection> connectionFuture = entry.isReadOnlyMode() ? this.connectionManager.connectionReadOp(source, null) : this.connectionManager.connectionWriteOp(source, null);
        final int attempts = retryAttempts > 0 ? retryAttempts : this.connectionManager.getConfig().getRetryAttempts();
        final FutureListener<Void> mainPromiseListener = new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isCancelled() && connectionFuture.cancel(false)) {
                    CommandAsyncService.log.debug("Connection obtaining canceled for batch");
                    details.getTimeout().cancel();
                    if (attemptPromise.cancel(false)) {
                        CommandBatchService.this.free(entry);
                    }
                }
            }
        };
        TimerTask retryTimerTask = new TimerTask(){

            @Override
            public void run(Timeout t) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    CommandBatchService.this.connectionManager.getShutdownLatch().release();
                } else if (connectionFuture.isSuccess()) {
                    if (details.getWriteFuture() == null || !details.getWriteFuture().isDone()) {
                        if (details.getAttempt() == attempts) {
                            if (details.getWriteFuture().cancel(false)) {
                                if (details.getException() == null) {
                                    details.setException(new RedisTimeoutException("Unable to send batch after " + CommandBatchService.this.connectionManager.getConfig().getRetryAttempts() + " retry attempts"));
                                }
                                attemptPromise.tryFailure(details.getException());
                            }
                            return;
                        }
                        details.incAttempt();
                        Timeout timeout = CommandBatchService.this.connectionManager.newTimeout(this, CommandBatchService.this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                        details.setTimeout(timeout);
                        return;
                    }
                    if (details.getWriteFuture().isDone() && details.getWriteFuture().isSuccess()) {
                        return;
                    }
                }
                if (mainPromise.isCancelled()) {
                    if (attemptPromise.cancel(false)) {
                        CommandBatchService.this.free(entry);
                    }
                    return;
                }
                if (attempt == attempts) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Batch command execution timeout"));
                    }
                    attemptPromise.tryFailure(details.getException());
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                int count = attempt + 1;
                mainPromise.removeListener(mainPromiseListener);
                CommandBatchService.this.execute(entry, source, mainPromise, slots, count, noResult, responseTimeout, retryAttempts, retryInterval);
            }
        };
        long interval = this.connectionManager.getConfig().getRetryInterval();
        if (retryInterval > 0L) {
            interval = retryInterval;
        }
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, interval, TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        mainPromise.addListener((FutureListener)mainPromiseListener);
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> connFuture) throws Exception {
                CommandBatchService.this.checkConnectionFuture(entry, source, mainPromise, attemptPromise, details, connectionFuture, noResult, responseTimeout, attempts);
            }
        });
        attemptPromise.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                details.getTimeout().cancel();
                if (future.isCancelled()) {
                    return;
                }
                mainPromise.removeListener(mainPromiseListener);
                if (future.cause() instanceof RedisMovedException) {
                    RedisMovedException ex = (RedisMovedException)future.cause();
                    entry.clearErrors();
                    NodeSource nodeSource = new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.MOVED);
                    CommandBatchService.this.execute(entry, nodeSource, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisAskException) {
                    RedisAskException ex = (RedisAskException)future.cause();
                    entry.clearErrors();
                    NodeSource nodeSource = new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.ASK);
                    CommandBatchService.this.execute(entry, nodeSource, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisLoadingException) {
                    entry.clearErrors();
                    CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                    return;
                }
                if (future.cause() instanceof RedisTryAgainException) {
                    entry.clearErrors();
                    CommandBatchService.this.connectionManager.newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt, noResult, responseTimeout, retryAttempts, retryInterval);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    return;
                }
                CommandBatchService.this.free(entry);
                if (future.isSuccess()) {
                    if (slots.decrementAndGet() == 0) {
                        mainPromise.trySuccess(future.getNow());
                    }
                } else {
                    mainPromise.tryFailure(future.cause());
                }
            }
        });
    }

    protected void free(Entry entry) {
        for (BatchCommandData<?, ?> command : entry.getCommands()) {
            this.free(command.getParams());
        }
    }

    private void checkWriteFuture(Entry entry, final RPromise<Void> attemptPromise, AsyncDetails details, final RedisConnection connection, ChannelFuture future, boolean noResult, long responseTimeout, int attempts) {
        if (future.isCancelled() || attemptPromise.isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            details.setException(new WriteRedisConnectionException("Can't write command batch to channel: " + future.channel(), future.cause()));
            if (details.getAttempt() == attempts) {
                attemptPromise.tryFailure(details.getException());
            }
            return;
        }
        details.getTimeout().cancel();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                attemptPromise.tryFailure(new RedisTimeoutException("Redis server response timeout during command batch execution. Channel: " + connection.getChannel()));
            }
        };
        long timeout = this.connectionManager.getConfig().getTimeout();
        if (responseTimeout > 0L) {
            timeout = responseTimeout;
        }
        Timeout timeoutTask = this.connectionManager.newTimeout(timerTask, timeout, TimeUnit.MILLISECONDS);
        details.setTimeout(timeoutTask);
    }

    private void checkConnectionFuture(final Entry entry, NodeSource source, RPromise<Void> mainPromise, final RPromise<Void> attemptPromise, final AsyncDetails details, RFuture<RedisConnection> connFuture, final boolean noResult, final long responseTimeout, final int attempts) {
        if (connFuture.isCancelled()) {
            return;
        }
        if (!connFuture.isSuccess()) {
            this.connectionManager.getShutdownLatch().release();
            details.setException(this.convertException(connFuture));
            return;
        }
        if (attemptPromise.isDone() || mainPromise.isDone()) {
            this.releaseConnection(source, connFuture, details.isReadOnlyMode(), attemptPromise, details);
            return;
        }
        final RedisConnection connection = connFuture.getNow();
        ArrayList list = new ArrayList(entry.getCommands().size() + 1);
        if (source.getRedirect() == NodeSource.Redirect.ASK) {
            RedissonPromise promise = new RedissonPromise();
            list.add(new CommandData(promise, StringCodec.INSTANCE, RedisCommands.ASKING, new Object[0]));
        }
        for (BatchCommandData batchCommandData : entry.getCommands()) {
            if (batchCommandData.getPromise().isSuccess() && !this.isWaitCommand(batchCommandData)) continue;
            list.add(batchCommandData);
        }
        ChannelFuture future = connection.send(new CommandsData(attemptPromise, list, noResult));
        details.setWriteFuture(future);
        details.getWriteFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                CommandBatchService.this.checkWriteFuture(entry, attemptPromise, details, connection, future, noResult, responseTimeout, attempts);
            }
        });
        this.releaseConnection(source, connFuture, entry.isReadOnlyMode(), attemptPromise, details);
    }

    protected boolean isWaitCommand(BatchCommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName());
    }

    public static class Entry {
        Deque<BatchCommandData<?, ?>> commands = new LinkedBlockingDeque();
        volatile boolean readOnlyMode = true;

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }
}

