/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RObject;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RObjectField;
import org.redisson.client.codec.Codec;
import org.redisson.codec.CodecProvider;
import org.redisson.liveobject.misc.ClassUtils;

public class DefaultCodecProvider
implements CodecProvider {
    public final transient ConcurrentMap<Class<? extends Codec>, Codec> codecCache = PlatformDependent.newConcurrentHashMap();

    @Override
    public <T extends Codec> T getCodec(Class<T> codecClass) {
        if (!this.codecCache.containsKey(codecClass)) {
            try {
                this.codecCache.putIfAbsent((Class<? extends Codec>)codecClass, (Codec)codecClass.newInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)((Codec)this.codecCache.get(codecClass));
    }

    @Override
    public <T extends Codec> T getCodec(REntity anno, Class<?> cls) {
        if (!ClassUtils.isAnnotationPresent(cls, anno.annotationType())) {
            throw new IllegalArgumentException("Annotation REntity does not present on type [" + cls.getCanonicalName() + "]");
        }
        return (T)this.getCodec(anno.codec());
    }

    @Override
    public <T extends Codec, K extends RObject> T getCodec(RObjectField anno, Class<?> cls, Class<K> rObjectClass, String fieldName) {
        try {
            if (!ClassUtils.getDeclaredField(cls, fieldName).isAnnotationPresent(anno.getClass())) {
                throw new IllegalArgumentException("Annotation RObjectField does not present on field " + fieldName + " of type [" + cls.getCanonicalName() + "]");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot lookup an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        return (T)this.getCodec(anno.codec());
    }

    @Override
    public <T extends Codec, K extends RObject> T getCodec(Class<T> codecClass, Class<K> rObjectClass) {
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot lookup an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        return this.getCodec(codecClass);
    }

    @Override
    public <T extends Codec, K extends RObject> T getCodec(Class<T> codecClass, Class<K> rObjectClass, String name) {
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot lookup an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        return this.getCodec(codecClass, rObjectClass);
    }

    @Override
    public <T extends Codec> T getCodec(Class<T> codecClass, RObject rObject) {
        return this.getCodec(codecClass, rObject.getClass(), rObject.getName());
    }

    @Override
    public <T extends Codec> void registerCodec(Class<T> cls, T codec) {
        if (!cls.isInstance(codec)) {
            throw new IllegalArgumentException("codec is not an instance of the class [" + cls.getCanonicalName() + "]");
        }
        this.codecCache.putIfAbsent(cls, codec);
    }

    @Override
    public <T extends Codec> void registerCodec(REntity anno, Class<?> cls, T codec) {
        if (!cls.isAnnotationPresent(anno.getClass())) {
            throw new IllegalArgumentException("Annotation REntity does not present on type [" + cls.getCanonicalName() + "]");
        }
        this.registerCodec(anno.codec(), codec);
    }

    @Override
    public <T extends Codec, K extends RObject> void registerCodec(RObjectField anno, Class<?> cls, Class<K> rObjectClass, String fieldName, T codec) {
        try {
            if (!cls.getField(fieldName).isAnnotationPresent(anno.getClass())) {
                throw new IllegalArgumentException("Annotation RObjectField does not present on field " + fieldName + " of type [" + cls.getCanonicalName() + "]");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot lookup an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        this.registerCodec(anno.codec(), codec);
    }

    @Override
    public <T extends Codec, K extends RObject> void registerCodec(Class<T> codecClass, Class<K> rObjectClass, T codec) {
        if (rObjectClass.isInterface()) {
            throw new IllegalArgumentException("Cannot register an interface class of RObject [" + rObjectClass.getCanonicalName() + "]. Concrete class only.");
        }
        this.registerCodec(codecClass, codec);
    }

    @Override
    public <T extends Codec, K extends RObject> void registerCodec(Class<T> codecClass, Class<K> rObjectClass, String name, T codec) {
        this.registerCodec(codecClass, rObjectClass, codec);
    }

    @Override
    public <T extends Codec> void registerCodec(Class<T> codecClass, RObject rObject, T codec) {
        this.registerCodec(codecClass, rObject.getClass(), rObject.getName(), codec);
    }
}

