/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    private static final int BACKOFF_CAP = 12;

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channels.add(ctx.channel());
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        if (connection != null) {
            ((RedisConnection)connection).fireDisconnected();
            if (!((RedisConnection)connection).isClosed()) {
                if (((RedisConnection)connection).isFastReconnect()) {
                    this.tryReconnect((RedisConnection)connection, 1);
                } else {
                    this.reconnect((RedisConnection)connection, 1);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    private void reconnect(final RedisConnection connection, final int attempts) {
        int timeout = 2 << attempts;
        if (this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        try {
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    ConnectionWatchdog.this.tryReconnect(connection, Math.min(12, attempts + 1));
                }
            }, timeout, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void tryReconnect(final RedisConnection connection, final int nextAttempt) {
        if (connection.isClosed() || this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        this.log.debug("reconnecting {} to {} ", connection, connection.getRedisClient().getAddr(), connection);
        try {
            this.bootstrap.connect().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (connection.isClosed() || ConnectionWatchdog.this.bootstrap.config().group().isShuttingDown()) {
                        return;
                    }
                    if (future.isSuccess()) {
                        final Channel channel = future.channel();
                        Object c = RedisConnection.getFrom(channel);
                        ((RedisConnection)c).getConnectionPromise().addListener(new FutureListener<RedisConnection>(){

                            @Override
                            public void operationComplete(Future<RedisConnection> future) throws Exception {
                                if (future.isSuccess()) {
                                    ConnectionWatchdog.this.refresh(connection, channel);
                                    ConnectionWatchdog.this.log.debug("{} connected to {}, command: {}", connection, connection.getRedisClient().getAddr(), connection.getCurrentCommand());
                                } else {
                                    ConnectionWatchdog.this.log.warn("Can't connect " + connection + " to " + connection.getRedisClient().getAddr(), future.cause());
                                }
                            }
                        });
                        return;
                    }
                    ConnectionWatchdog.this.reconnect(connection, nextAttempt);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void reattachPubSub(RedisConnection connection) {
        if (connection instanceof RedisPubSubConnection) {
            RedisPubSubConnection conn = (RedisPubSubConnection)connection;
            for (Map.Entry<String, Codec> entry : conn.getChannels().entrySet()) {
                conn.subscribe(entry.getValue(), entry.getKey());
            }
            for (Map.Entry<String, Codec> entry : conn.getPatternChannels().entrySet()) {
                conn.psubscribe(entry.getValue(), entry.getKey());
            }
        }
    }

    private void refresh(RedisConnection connection, Channel channel) {
        CommandData currentCommand = connection.getCurrentCommand();
        connection.fireConnected();
        connection.updateChannel(channel);
        if (connection.isFastReconnect()) {
            connection.clearFastReconnect();
        }
        this.reattachBlockingQueue(connection, currentCommand);
        this.reattachPubSub(connection);
    }

    private void reattachBlockingQueue(RedisConnection connection, CommandData<?, ?> currentCommand) {
        if (currentCommand == null || !currentCommand.isBlockingCommand() || currentCommand.getPromise().isDone()) {
            return;
        }
        this.log.debug("blocking queue sent " + connection);
        ChannelFuture future = connection.send(currentCommand);
        final CommandData<?, ?> cd = currentCommand;
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ConnectionWatchdog.this.log.error("Can't reconnect blocking queue to new connection. {}", (Object)cd);
                }
            }
        });
    }
}

