/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxLift;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoLift;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.ParallelLift;
import reactor.core.publisher.SerializedSubscriber;
import reactor.core.publisher.StrictSubscriber;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public abstract class Operators {
    static final CoreSubscriber<?> EMPTY_SUBSCRIBER = new CoreSubscriber<Object>(){

        @Override
        public void onSubscribe(Subscription s) {
            IllegalStateException e = new IllegalStateException("onSubscribe should not be used");
            log.error("Unexpected call to Operators.emptySubscriber()", e);
        }

        @Override
        public void onNext(Object o) {
            IllegalStateException e = new IllegalStateException("onNext should not be used, got " + o);
            log.error("Unexpected call to Operators.emptySubscriber()", e);
        }

        @Override
        public void onError(Throwable t) {
            IllegalStateException e = new IllegalStateException("onError should not be used", t);
            log.error("Unexpected call to Operators.emptySubscriber()", e);
        }

        @Override
        public void onComplete() {
            IllegalStateException e = new IllegalStateException("onComplete should not be used");
            log.error("Unexpected call to Operators.emptySubscriber()", e);
        }
    };
    static final Logger log = Loggers.getLogger(Operators.class);

    public static long addCap(long a, long b) {
        long res = a + b;
        if (res < 0L) {
            return Long.MAX_VALUE;
        }
        return res;
    }

    public static <T> long addCap(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, toAdd)));
        return r;
    }

    @Nullable
    public static <T> Fuseable.QueueSubscription<T> as(Subscription s) {
        if (s instanceof Fuseable.QueueSubscription) {
            return (Fuseable.QueueSubscription)s;
        }
        return null;
    }

    public static Subscription cancelledSubscription() {
        return CancelledSubscription.INSTANCE;
    }

    public static void complete(Subscriber<?> s) {
        s.onSubscribe(EmptySubscription.INSTANCE);
        s.onComplete();
    }

    public static <T> CoreSubscriber<T> drainSubscriber() {
        return DrainSubscriber.INSTANCE;
    }

    public static <T> CoreSubscriber<T> emptySubscriber() {
        return EMPTY_SUBSCRIBER;
    }

    public static Subscription emptySubscription() {
        return EmptySubscription.INSTANCE;
    }

    public static void error(Subscriber<?> s, Throwable e) {
        s.onSubscribe(EmptySubscription.INSTANCE);
        s.onError(e);
    }

    public static <I, O> Function<? super Publisher<I>, ? extends Publisher<O>> lift(BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        return new LiftFunction(null, lifter);
    }

    public static <O> Function<? super Publisher<O>, ? extends Publisher<O>> lift(Predicate<Scannable> filter, BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super O>> lifter) {
        return new LiftFunction(filter, lifter);
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && u / a != b) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static void onErrorDropped(Throwable e, Context context) {
        Consumer<? super Throwable> hook = context.getOrDefault("reactor.onErrorDropped.local", null);
        if (hook == null) {
            hook = Hooks.onErrorDroppedHook;
        }
        if (hook == null) {
            throw Exceptions.bubble(e);
        }
        hook.accept(e);
    }

    public static <T> void onNextDropped(T t, Context context) {
        Objects.requireNonNull(t, "onNext");
        Objects.requireNonNull(context, "context");
        Consumer<Object> hook = context.getOrDefault("reactor.onNextDropped.local", null);
        if (hook == null) {
            hook = Hooks.onNextDroppedHook;
        }
        if (hook != null) {
            hook.accept(t);
        } else if (log.isDebugEnabled()) {
            log.debug("onNextDropped: " + t);
        }
    }

    public static Throwable onOperatorError(Throwable error, Context context) {
        return Operators.onOperatorError(null, error, context);
    }

    public static Throwable onOperatorError(@Nullable Subscription subscription, Throwable error, Context context) {
        return Operators.onOperatorError(subscription, error, null, context);
    }

    public static Throwable onOperatorError(@Nullable Subscription subscription, Throwable error, @Nullable Object dataSignal, Context context) {
        Exceptions.throwIfFatal(error);
        if (subscription != null) {
            subscription.cancel();
        }
        Throwable t = Exceptions.unwrap(error);
        BiFunction<? super Throwable, Object, ? extends Throwable> hook = context.getOrDefault("reactor.onOperatorError.local", null);
        if (hook == null) {
            hook = Hooks.onOperatorErrorHook;
        }
        if (hook == null) {
            if (dataSignal != null && dataSignal != t && dataSignal instanceof Throwable) {
                t = Exceptions.addSuppressed(t, (Throwable)dataSignal);
            }
            return t;
        }
        return hook.apply(error, dataSignal);
    }

    public static RuntimeException onRejectedExecution(Throwable original, Context context) {
        return Operators.onRejectedExecution(original, null, null, null, context);
    }

    public static RuntimeException onRejectedExecution(Throwable original, @Nullable Subscription subscription, @Nullable Throwable suppressed, @Nullable Object dataSignal, Context context) {
        if (context.hasKey("reactor.onRejectedExecution.local")) {
            context = context.put("reactor.onOperatorError.local", context.get("reactor.onRejectedExecution.local"));
        }
        RejectedExecutionException ree = Exceptions.failWithRejected(original);
        if (suppressed != null) {
            ree.addSuppressed(suppressed);
        }
        if (dataSignal != null) {
            return Exceptions.propagate(Operators.onOperatorError(subscription, ree, dataSignal, context));
        }
        return Exceptions.propagate(Operators.onOperatorError(subscription, ree, context));
    }

    public static <T> long produced(AtomicLongFieldUpdater<T> updater, T instance, long toSub) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!updater.compareAndSet(instance, r, u = Operators.subOrZero(r, toSub)));
        return u;
    }

    public static <F> boolean replace(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Subscription a;
        do {
            if ((a = field.get(instance)) != CancelledSubscription.INSTANCE) continue;
            s.cancel();
            return false;
        } while (!field.compareAndSet(instance, a, s));
        return true;
    }

    public static void reportBadRequest(long n) {
        if (log.isDebugEnabled()) {
            log.debug("Negative request", Exceptions.nullOrNegativeRequestException(n));
        }
    }

    public static void reportMoreProduced() {
        if (log.isDebugEnabled()) {
            log.debug("More data produced than requested", Exceptions.failWithOverflow());
        }
    }

    public static void reportSubscriptionSet() {
        if (log.isDebugEnabled()) {
            log.debug("Duplicate Subscription has been detected", Exceptions.duplicateOnSubscribeException());
        }
    }

    public static <T> Subscription scalarSubscription(CoreSubscriber<? super T> subscriber, T value) {
        return new ScalarSubscription<T>(subscriber, value);
    }

    public static <T> CoreSubscriber<T> serialize(CoreSubscriber<? super T> subscriber) {
        return new SerializedSubscriber<T>(subscriber);
    }

    public static <F> boolean set(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Subscription a;
        do {
            if ((a = field.get(instance)) != CancelledSubscription.INSTANCE) continue;
            s.cancel();
            return false;
        } while (!field.compareAndSet(instance, a, s));
        if (a != null) {
            a.cancel();
        }
        return true;
    }

    public static <F> boolean setOnce(AtomicReferenceFieldUpdater<F, Subscription> field, F instance, Subscription s) {
        Objects.requireNonNull(s, "subscription");
        Subscription a = field.get(instance);
        if (a == CancelledSubscription.INSTANCE) {
            s.cancel();
            return false;
        }
        if (a != null) {
            s.cancel();
            Operators.reportSubscriptionSet();
            return false;
        }
        if (field.compareAndSet(instance, null, s)) {
            return true;
        }
        a = field.get(instance);
        if (a == CancelledSubscription.INSTANCE) {
            s.cancel();
            return false;
        }
        s.cancel();
        Operators.reportSubscriptionSet();
        return false;
    }

    public static long subOrZero(long a, long b) {
        long res = a - b;
        if (res < 0L) {
            return 0L;
        }
        return res;
    }

    public static <F> boolean terminate(AtomicReferenceFieldUpdater<F, Subscription> field, F instance) {
        Subscription a = field.get(instance);
        if (a != CancelledSubscription.INSTANCE && (a = field.getAndSet(instance, CancelledSubscription.INSTANCE)) != null && a != CancelledSubscription.INSTANCE) {
            a.cancel();
            return true;
        }
        return false;
    }

    public static boolean validate(@Nullable Subscription current, Subscription next) {
        Objects.requireNonNull(next, "Subscription cannot be null");
        if (current != null) {
            next.cancel();
            return false;
        }
        return true;
    }

    public static boolean validate(long n) {
        if (n <= 0L) {
            Operators.reportBadRequest(n);
            return false;
        }
        return true;
    }

    static <F> boolean setTerminated(AtomicReferenceFieldUpdater<F, Subscription> field, F instance) {
        Subscription a = field.get(instance);
        return a != CancelledSubscription.INSTANCE && ((a = field.getAndSet(instance, CancelledSubscription.INSTANCE)) == null || a != CancelledSubscription.INSTANCE);
    }

    public static <T> CoreSubscriber<? super T> toCoreSubscriber(Subscriber<? super T> actual) {
        Objects.requireNonNull(actual, "actual");
        StrictSubscriber<? super T> _actual = actual instanceof CoreSubscriber ? (StrictSubscriber<? super T>)actual : new StrictSubscriber<T>(actual);
        return _actual;
    }

    static <T> long addCapCancellable(AtomicLongFieldUpdater<T> updater, T instance, long n) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MIN_VALUE && r != Long.MAX_VALUE) continue;
            return r;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, n)));
        return r;
    }

    static void onErrorDroppedMulticast(Throwable e) {
        Operators.onErrorDropped(e, Context.empty());
    }

    static <T> void onNextDroppedMulticast(T t) {
        Operators.onNextDropped(t, Context.empty());
    }

    static <T> long producedCancellable(AtomicLongFieldUpdater<T> updater, T instance, long n) {
        long update;
        long current;
        do {
            if ((current = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (current == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            Operators.reportBadRequest(update);
            update = 0L;
        } while (!updater.compareAndSet(instance, current, update));
        return update;
    }

    static long unboundedOrPrefetch(int prefetch) {
        return prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)prefetch;
    }

    static int unboundedOrLimit(int prefetch) {
        return prefetch == Integer.MAX_VALUE ? Integer.MAX_VALUE : prefetch - (prefetch >> 2);
    }

    static int unboundedOrLimit(int prefetch, int lowTide) {
        if (lowTide >= prefetch) {
            return Operators.unboundedOrLimit(prefetch);
        }
        return prefetch == Integer.MAX_VALUE ? Integer.MAX_VALUE : lowTide;
    }

    Operators() {
    }

    static final class LiftFunction<I, O>
    implements Function<Publisher<I>, Publisher<O>> {
        final Predicate<Scannable> filter;
        final BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

        LiftFunction(@Nullable Predicate<Scannable> filter, BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
            this.filter = filter;
            this.lifter = Objects.requireNonNull(lifter, "lifter");
        }

        @Override
        public Publisher<O> apply(Publisher<I> publisher) {
            if (this.filter != null && !this.filter.test(Scannable.from(publisher))) {
                return publisher;
            }
            if (publisher instanceof Mono) {
                return new MonoLift(publisher, this.lifter);
            }
            if (publisher instanceof ParallelFlux) {
                return new ParallelLift((ParallelFlux)publisher, this.lifter);
            }
            return new FluxLift(publisher, this.lifter);
        }
    }

    static final class DrainSubscriber<T>
    implements CoreSubscriber<T> {
        static final DrainSubscriber INSTANCE = new DrainSubscriber();

        DrainSubscriber() {
        }

        @Override
        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object o) {
        }

        @Override
        public void onError(Throwable t) {
            Operators.onErrorDropped(Exceptions.errorCallbackNotImplemented(t), Context.empty());
        }

        @Override
        public void onComplete() {
        }
    }

    static final class ScalarSubscription<T>
    implements Fuseable.SynchronousSubscription<T>,
    InnerProducer<T> {
        final CoreSubscriber<? super T> actual;
        final T value;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScalarSubscription> ONCE = AtomicIntegerFieldUpdater.newUpdater(ScalarSubscription.class, "once");

        ScalarSubscription(CoreSubscriber<? super T> actual, T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.actual = Objects.requireNonNull(actual, "actual");
        }

        @Override
        public void cancel() {
            ONCE.lazySet(this, 2);
        }

        @Override
        public void clear() {
            ONCE.lazySet(this, 1);
        }

        @Override
        public boolean isEmpty() {
            return this.once != 0;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public T poll() {
            if (this.once == 0) {
                ONCE.lazySet(this, 1);
                return this.value;
            }
            return null;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.once == 1;
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                CoreSubscriber<T> a = this.actual;
                a.onNext(this.value);
                if (this.once != 2) {
                    a.onComplete();
                }
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }
    }

    static abstract class MultiSubscriptionSubscriber<I, O>
    implements InnerOperator<I, O> {
        final CoreSubscriber<? super O> actual;
        protected boolean unbounded;
        Subscription subscription;
        long requested;
        volatile Subscription missedSubscription;
        volatile long missedRequested;
        volatile long missedProduced;
        volatile int wip;
        volatile boolean cancelled;
        static final AtomicReferenceFieldUpdater<MultiSubscriptionSubscriber, Subscription> MISSED_SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, Subscription.class, "missedSubscription");
        static final AtomicLongFieldUpdater<MultiSubscriptionSubscriber> MISSED_REQUESTED = AtomicLongFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "missedRequested");
        static final AtomicLongFieldUpdater<MultiSubscriptionSubscriber> MISSED_PRODUCED = AtomicLongFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "missedProduced");
        static final AtomicIntegerFieldUpdater<MultiSubscriptionSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(MultiSubscriptionSubscriber.class, "wip");

        public MultiSubscriptionSubscriber(CoreSubscriber<? super O> actual) {
            this.actual = actual;
        }

        @Override
        public CoreSubscriber<? super O> actual() {
            return this.actual;
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.drain();
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.missedSubscription != null ? this.missedSubscription : this.subscription;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.isCancelled();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return Operators.addCap(this.requested, this.missedRequested);
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public final boolean isUnbounded() {
            return this.unbounded;
        }

        final boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.set(s);
        }

        public final void produced(long n) {
            if (this.unbounded) {
                return;
            }
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    long u = r - n;
                    if (u < 0L) {
                        Operators.reportMoreProduced();
                        u = 0L;
                    }
                    this.requested = u;
                } else {
                    this.unbounded = true;
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
                return;
            }
            Operators.addCap(MISSED_PRODUCED, this, n);
            this.drain();
        }

        final void producedOne() {
            if (this.unbounded) {
                return;
            }
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    if (--r < 0L) {
                        Operators.reportMoreProduced();
                        r = 0L;
                    }
                    this.requested = r;
                } else {
                    this.unbounded = true;
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
                return;
            }
            Operators.addCap(MISSED_PRODUCED, this, 1L);
            this.drain();
        }

        @Override
        public final void request(long n) {
            if (Operators.validate(n)) {
                if (this.unbounded) {
                    return;
                }
                if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                    long r = this.requested;
                    if (r != Long.MAX_VALUE) {
                        this.requested = r = Operators.addCap(r, n);
                        if (r == Long.MAX_VALUE) {
                            this.unbounded = true;
                        }
                    }
                    Subscription a = this.subscription;
                    if (WIP.decrementAndGet(this) != 0) {
                        this.drainLoop();
                    }
                    if (a != null) {
                        a.request(n);
                    }
                    return;
                }
                Operators.addCap(MISSED_REQUESTED, this, n);
                this.drain();
            }
        }

        public final void set(Subscription s) {
            if (this.cancelled) {
                s.cancel();
                return;
            }
            Objects.requireNonNull(s);
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                Subscription a = this.subscription;
                if (a != null && this.shouldCancelCurrent()) {
                    a.cancel();
                }
                this.subscription = s;
                long r = this.requested;
                if (WIP.decrementAndGet(this) != 0) {
                    this.drainLoop();
                }
                if (r != 0L) {
                    s.request(r);
                }
                return;
            }
            Subscription a = MISSED_SUBSCRIPTION.getAndSet(this, s);
            if (a != null && this.shouldCancelCurrent()) {
                a.cancel();
            }
            this.drain();
        }

        protected boolean shouldCancelCurrent() {
            return false;
        }

        final void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        }

        final void drainLoop() {
            int missed = 1;
            long requestAmount = 0L;
            Subscription requestTarget = null;
            do {
                long mp;
                long mr;
                Subscription ms;
                if ((ms = this.missedSubscription) != null) {
                    ms = MISSED_SUBSCRIPTION.getAndSet(this, null);
                }
                if ((mr = this.missedRequested) != 0L) {
                    mr = MISSED_REQUESTED.getAndSet(this, 0L);
                }
                if ((mp = this.missedProduced) != 0L) {
                    mp = MISSED_PRODUCED.getAndSet(this, 0L);
                }
                Subscription a = this.subscription;
                if (this.cancelled) {
                    if (a != null) {
                        a.cancel();
                        this.subscription = null;
                    }
                    if (ms == null) continue;
                    ms.cancel();
                    continue;
                }
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    long u = Operators.addCap(r, mr);
                    if (u != Long.MAX_VALUE) {
                        long v = u - mp;
                        if (v < 0L) {
                            Operators.reportMoreProduced();
                            v = 0L;
                        }
                        r = v;
                    } else {
                        r = u;
                    }
                    this.requested = r;
                }
                if (ms != null) {
                    if (a != null && this.shouldCancelCurrent()) {
                        a.cancel();
                    }
                    this.subscription = ms;
                    if (r == 0L) continue;
                    requestAmount = Operators.addCap(requestAmount, r);
                    requestTarget = ms;
                    continue;
                }
                if (mr == 0L || a == null) continue;
                requestAmount = Operators.addCap(requestAmount, mr);
                requestTarget = a;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            if (requestAmount != 0L) {
                requestTarget.request(requestAmount);
            }
        }
    }

    public static class MonoSubscriber<I, O>
    implements InnerOperator<I, O>,
    Fuseable,
    Fuseable.QueueSubscription<O> {
        protected final CoreSubscriber<? super O> actual;
        protected O value;
        volatile int state;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;
        static final int CANCELLED = 4;
        static final int FUSED_EMPTY = 8;
        static final int FUSED_READY = 16;
        static final int FUSED_CONSUMED = 32;
        static final AtomicIntegerFieldUpdater<MonoSubscriber> STATE = AtomicIntegerFieldUpdater.newUpdater(MonoSubscriber.class, "state");

        public MonoSubscriber(CoreSubscriber<? super O> actual) {
            this.actual = actual;
        }

        @Override
        public void cancel() {
            this.state = 4;
            this.value = null;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.isCancelled();
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.state == 3 || this.state == 1;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public final void clear() {
            STATE.lazySet(this, 32);
            this.value = null;
        }

        public final void complete(O v) {
            int state = this.state;
            do {
                if (state == 8) {
                    this.setValue(v);
                    STATE.lazySet(this, 16);
                    CoreSubscriber<O> a = this.actual;
                    a.onNext(v);
                    if (this.state != 4) {
                        a.onComplete();
                    }
                    return;
                }
                if ((state & 0xFFFFFFFD) != 0) {
                    return;
                }
                if (state == 2) {
                    STATE.lazySet(this, 3);
                    CoreSubscriber<O> a = this.actual;
                    a.onNext(v);
                    if (this.state != 4) {
                        a.onComplete();
                    }
                    return;
                }
                this.setValue(v);
                if (!STATE.compareAndSet(this, 0, 1)) continue;
                return;
            } while ((state = this.state) != 4);
            this.value = null;
        }

        @Override
        public final CoreSubscriber<? super O> actual() {
            return this.actual;
        }

        public final boolean isCancelled() {
            return this.state == 4;
        }

        @Override
        public final boolean isEmpty() {
            return this.state != 16;
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onNext(I t) {
            this.setValue(t);
        }

        @Override
        public void onSubscribe(Subscription s) {
        }

        @Override
        @Nullable
        public final O poll() {
            if (STATE.get(this) == 16) {
                STATE.lazySet(this, 32);
                O v = this.value;
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                do {
                    O v;
                    int s;
                    if (((s = this.state) & 0xFFFFFFFE) != 0) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, 1, 3) && (v = this.value) != null) {
                        this.value = null;
                        CoreSubscriber<O> a = this.actual;
                        a.onNext(v);
                        if (this.state != 4) {
                            a.onComplete();
                        }
                    }
                    return;
                } while (!STATE.compareAndSet(this, 0, 2));
                return;
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                STATE.lazySet(this, 8);
                return 2;
            }
            return 0;
        }

        public void setValue(O value) {
            this.value = value;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }
    }

    public static class DeferredSubscription
    implements Subscription,
    Scannable {
        volatile Subscription s;
        volatile long requested;
        static final AtomicReferenceFieldUpdater<DeferredSubscription, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(DeferredSubscription.class, Subscription.class, "s");
        static final AtomicLongFieldUpdater<DeferredSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(DeferredSubscription.class, "requested");

        protected boolean isCancelled() {
            return this.s == Operators.cancelledSubscription();
        }

        @Override
        public void cancel() {
            Subscription a = this.s;
            if (a != Operators.cancelledSubscription() && (a = S.getAndSet(this, Operators.cancelledSubscription())) != null && a != Operators.cancelledSubscription()) {
                a.cancel();
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.isCancelled();
            }
            return null;
        }

        @Override
        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else {
                long r;
                Operators.addCap(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(r);
                }
            }
        }

        public final boolean set(Subscription s) {
            Objects.requireNonNull(s, "s");
            Subscription a = this.s;
            if (a == Operators.cancelledSubscription()) {
                s.cancel();
                return false;
            }
            if (a != null) {
                s.cancel();
                Operators.reportSubscriptionSet();
                return false;
            }
            if (S.compareAndSet(this, null, s)) {
                long r = REQUESTED.getAndSet(this, 0L);
                if (r != 0L) {
                    s.request(r);
                }
                return true;
            }
            a = this.s;
            if (a != Operators.cancelledSubscription()) {
                s.cancel();
                Operators.reportSubscriptionSet();
                return false;
            }
            return false;
        }
    }

    static final class EmptySubscription
    implements Fuseable.QueueSubscription<Object>,
    Scannable {
        static final EmptySubscription INSTANCE = new EmptySubscription();

        EmptySubscription() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nullable
        public Object poll() {
            return null;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return true;
            }
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class CancelledSubscription
    implements Subscription,
    Scannable {
        static final CancelledSubscription INSTANCE = new CancelledSubscription();

        CancelledSubscription() {
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return true;
            }
            return null;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void request(long n) {
        }
    }
}

