/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetReactive<V>
extends RedissonExpirableReactive
implements RSetReactive<V> {
    private final RedissonSet<V> instance;

    public RedissonSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonSet(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name, null);
    }

    public RedissonSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonSet(codec, commandExecutor, name, null);
    }

    @Override
    public Publisher<Integer> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this).addAll(c);
    }

    @Override
    public Publisher<Integer> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.SCARD_INT, this.getName());
    }

    @Override
    public Publisher<Boolean> contains(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.containsAsync(o);
            }
        });
    }

    private Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), new ScanCodec(this.codec), RedisCommands.SSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<Integer> add(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<V> removeRandom() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonSetReactive.this.instance.removeRandomAsync();
            }
        });
    }

    @Override
    public Publisher<V> random() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonSetReactive.this.instance.randomAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.removeAsync(o);
            }
        });
    }

    @Override
    public Publisher<Boolean> move(final String destination, final V member) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.moveAsync(destination, member);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.containsAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> addAll(Collection<? extends V> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getName());
        this.encode(args, c);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, args.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.retainAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> removeAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.removeAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readIntersection(final String ... names) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readIntersectionAsync(names);
            }
        });
    }

    @Override
    public Publisher<Long> intersection(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SINTERSTORE, args.toArray());
    }

    @Override
    public Publisher<Long> diff(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SDIFFSTORE, args.toArray());
    }

    @Override
    public Publisher<Long> union(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SUNIONSTORE, args.toArray());
    }

    @Override
    public Publisher<Set<V>> readUnion(final String ... names) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readUnionAsync(names);
            }
        });
    }

    @Override
    public Publisher<V> iterator() {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long nextIterPos) {
                return RedissonSetReactive.this.scanIteratorReactive(client, nextIterPos);
            }
        });
    }
}

