/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.reactive.MapReactive;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class RedissonMapReactiveIterator<K, V, M>
implements Consumer<FluxSink<M>> {
    private final MapReactive<K, V> map;

    public RedissonMapReactiveIterator(MapReactive<K, V> map) {
        this.map = map;
    }

    @Override
    public void accept(final FluxSink<M> emitter) {
        emitter.onRequest(new LongConsumer(){
            private Map<ByteBuf, ByteBuf> firstValues;
            private Map<ByteBuf, ByteBuf> lastValues;
            private long nextIterPos;
            private InetSocketAddress client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(final FluxSink<M> emitter2) {
                RedissonMapReactiveIterator.this.map.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<MapScanResult<ScanObjectEntry, ScanObjectEntry>>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    private void free(Map<ByteBuf, ByteBuf> map) {
                        if (map == null) {
                            return;
                        }
                        for (Map.Entry<ByteBuf, ByteBuf> entry : map.entrySet()) {
                            entry.getKey().release();
                            entry.getValue().release();
                        }
                    }

                    @Override
                    public void onNext(MapScanResult<ScanObjectEntry, ScanObjectEntry> res) {
                        if (finished) {
                            this.free(firstValues);
                            this.free(lastValues);
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            return;
                        }
                        long prevIterPos = nextIterPos;
                        if (lastValues != null) {
                            this.free(lastValues);
                        }
                        lastValues = RedissonMapReactiveIterator.this.convert(res.getMap());
                        client = res.getRedisClient();
                        if (nextIterPos == 0L && firstValues == null) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty()) {
                                client = null;
                                firstValues = null;
                                nextIterPos = 0L;
                                prevIterPos = -1L;
                            }
                        } else if (firstValues.isEmpty()) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty() && res.getPos() == 0L) {
                                finished = true;
                                emitter2.complete();
                                return;
                            }
                        } else if (lastValues.keySet().removeAll(firstValues.keySet())) {
                            this.free(firstValues);
                            this.free(lastValues);
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            prevIterPos = -1L;
                            finished = true;
                            emitter2.complete();
                            return;
                        }
                        for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : res.getMap().entrySet()) {
                            Object val = RedissonMapReactiveIterator.this.getValue(entry);
                            emitter2.next(val);
                            elementsRead.incrementAndGet();
                        }
                        nextIterPos = res.getPos();
                        if (elementsRead.get() >= readAmount.get()) {
                            emitter2.complete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (prevIterPos == nextIterPos) {
                            finished = true;
                            emitter2.complete();
                        }
                    }

                    @Override
                    public void onError(Throwable error) {
                        emitter2.error(error);
                    }

                    @Override
                    public void onComplete() {
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues(emitter2);
                    }
                });
            }
        });
    }

    private Map<ByteBuf, ByteBuf> convert(Map<ScanObjectEntry, ScanObjectEntry> map) {
        HashMap<ByteBuf, ByteBuf> result = new HashMap<ByteBuf, ByteBuf>(map.size());
        for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : map.entrySet()) {
            result.put(entry.getKey().getBuf(), entry.getValue().getBuf());
        }
        return result;
    }

    M getValue(final Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey().getObj(), entry.getValue().getObj()){

            @Override
            public V setValue(V value) {
                Publisher publisher = RedissonMapReactiveIterator.this.map.put(((ScanObjectEntry)entry.getKey()).getObj(), value);
                return Mono.from(publisher).block();
            }
        };
    }
}

