/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class CountListener
implements FutureListener<Void> {
    private final RPromise<Void> res;
    private final AtomicInteger counter;

    public static RPromise<Void> create(RFuture<Void> ... futures) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        CountListener listener = new CountListener(result, futures.length);
        for (RFuture<Void> future : futures) {
            future.addListener(listener);
        }
        return result;
    }

    public CountListener(RPromise<Void> res, int amount) {
        this.res = res;
        this.counter = new AtomicInteger(amount);
    }

    @Override
    public void operationComplete(Future<Void> future) throws Exception {
        if (!future.isSuccess()) {
            this.res.tryFailure(future.cause());
            return;
        }
        if (this.counter.decrementAndGet() == 0) {
            this.res.trySuccess(null);
        }
    }
}

