/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.handler.CommandBatchEncoder;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandEncoder;
import org.redisson.client.handler.CommandPubSubDecoder;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.ConnectionWatchdog;
import org.redisson.client.handler.RedisConnectionHandler;
import org.redisson.client.handler.RedisPubSubConnectionHandler;
import org.redisson.config.SslProvider;

public class RedisChannelInitializer
extends ChannelInitializer<Channel> {
    private final RedisClientConfig config;
    private final RedisClient redisClient;
    private final ChannelGroup channels;
    private final Bootstrap bootstrap;
    private final Type type;

    public RedisChannelInitializer(Bootstrap bootstrap, RedisClientConfig config, RedisClient redisClient, ChannelGroup channels, Type type) {
        this.bootstrap = bootstrap;
        this.config = config;
        this.redisClient = redisClient;
        this.channels = channels;
        this.type = type;
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        this.initSsl(this.config, ch);
        if (this.type == Type.PLAIN) {
            ch.pipeline().addLast(new RedisConnectionHandler(this.redisClient));
        } else {
            ch.pipeline().addLast(new RedisPubSubConnectionHandler(this.redisClient));
        }
        ch.pipeline().addLast(new ConnectionWatchdog(this.bootstrap, this.channels, this.config.getTimer()), CommandEncoder.INSTANCE, CommandBatchEncoder.INSTANCE, new CommandsQueue());
        if (this.type == Type.PLAIN) {
            ch.pipeline().addLast(new CommandDecoder());
        } else {
            ch.pipeline().addLast(new CommandPubSubDecoder(this.config.getExecutor(), this.config.isKeepPubSubOrder()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSsl(RedisClientConfig config, Channel ch) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, SSLException, UnrecoverableKeyException {
        char[] password;
        InputStream stream;
        KeyStore keyStore;
        if (!"rediss".equals(config.getAddress().getScheme())) {
            return;
        }
        io.netty.handler.ssl.SslProvider provided = io.netty.handler.ssl.SslProvider.JDK;
        if (config.getSslProvider() == SslProvider.OPENSSL) {
            provided = io.netty.handler.ssl.SslProvider.OPENSSL;
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provided);
        if (config.getSslTruststore() != null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            stream = config.getSslTruststore().toURL().openStream();
            try {
                password = null;
                if (config.getSslTruststorePassword() != null) {
                    password = config.getSslTruststorePassword().toCharArray();
                }
                keyStore.load(stream, password);
            }
            finally {
                stream.close();
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContextBuilder.trustManager(trustManagerFactory);
        }
        if (config.getSslKeystore() != null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            stream = config.getSslKeystore().toURL().openStream();
            password = null;
            if (config.getSslKeystorePassword() != null) {
                password = config.getSslKeystorePassword().toCharArray();
            }
            try {
                keyStore.load(stream, password);
            }
            finally {
                stream.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            sslContextBuilder.keyManager(keyManagerFactory);
        }
        SSLParameters sslParams = new SSLParameters();
        if (config.isSslEnableEndpointIdentification()) {
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        } else if (config.getSslTruststore() == null) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        SslContext sslContext = sslContextBuilder.build();
        SSLEngine sslEngine = sslContext.newEngine(ch.alloc(), config.getAddress().getHost(), config.getAddress().getPort());
        sslEngine.setSSLParameters(sslParams);
        SslHandler sslHandler = new SslHandler(sslEngine);
        ch.pipeline().addLast(sslHandler);
        ch.pipeline().addLast(new ChannelInboundHandlerAdapter(){
            volatile boolean sslInitDone;

            @Override
            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                if (this.sslInitDone) {
                    super.channelActive(ctx);
                }
            }

            @Override
            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (!this.sslInitDone && evt instanceof SslHandshakeCompletionEvent) {
                    SslHandshakeCompletionEvent e = (SslHandshakeCompletionEvent)evt;
                    if (e.isSuccess()) {
                        this.sslInitDone = true;
                        ctx.fireChannelActive();
                    } else {
                        Object connection = RedisConnection.getFrom(ctx.channel());
                        ((RedisConnection)connection).getConnectionPromise().tryFailure(e.cause());
                    }
                }
                super.userEventTriggered(ctx, evt);
            }
        });
    }

    public static enum Type {
        PUBSUB,
        PLAIN;

    }
}

