/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.RedissonReference;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.misc.RedissonObjectFactory;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.AsyncSemaphore;

public class RedissonTopic<M>
implements RTopic<M> {
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    private final Codec codec;

    public RedissonTopic(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.codec = codec;
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public long publish(M message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    @Override
    public RFuture<Long> publishAsync(M message) {
        return this.commandExecutor.writeAsync(this.name, this.codec, RedisCommands.PUBLISH, this.name, this.encode(message));
    }

    protected ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int addListener(StatusListener listener) {
        return this.addListener(new PubSubStatusListener(listener, this.name));
    }

    @Override
    public int addListener(MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(listener, this.name);
        return this.addListener((RedisPubSubListener<?>)pubSubListener);
    }

    @Override
    private int addListener(RedisPubSubListener<?> pubSubListener) {
        RFuture<PubSubConnectionEntry> future = this.commandExecutor.getConnectionManager().subscribe(this.codec, this.name, pubSubListener);
        this.commandExecutor.syncSubscription(future);
        return System.identityHashCode(pubSubListener);
    }

    public RFuture<Integer> addListenerAsync(final RedisPubSubListener<?> pubSubListener) {
        RFuture<PubSubConnectionEntry> future = this.commandExecutor.getConnectionManager().subscribe(this.codec, this.name, pubSubListener);
        final RedissonPromise<Integer> result = new RedissonPromise<Integer>();
        future.addListener(new FutureListener<PubSubConnectionEntry>(){

            @Override
            public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                result.trySuccess(System.identityHashCode(pubSubListener));
            }
        });
        return result;
    }

    @Override
    public void removeAllListeners() {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeAllListeners(this.name);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().unsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public void removeListener(MessageListener<?> listener) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listener);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().unsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listenerId);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().unsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }
}

