/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.UnsafeMemoryInput;
import com.esotericsoftware.kryo.io.UnsafeMemoryOutput;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.SerializationCodec;

public class KryoCodec<IN, OUT>
extends SerializationCodec<Kryo, IN, OUT> {
    public KryoCodec() {
        super(new Kryo(), true);
    }

    public KryoCodec(Kryo engine, boolean lengthFieldFraming) {
        super(engine, lengthFieldFraming);
    }

    @Override
    protected Function<byte[], IN> deserializer(final Kryo engine, final Class<IN> type, final Consumer<IN> next) {
        return new Function<byte[], IN>(){

            @Override
            public IN apply(byte[] bytes) {
                Object obj = engine.readObject(new UnsafeMemoryInput(bytes), type);
                if (null != next) {
                    next.accept(obj);
                    return null;
                }
                return obj;
            }
        };
    }

    @Override
    protected Function<OUT, byte[]> serializer(final Kryo engine) {
        return new Function<OUT, byte[]>(){

            @Override
            public byte[] apply(OUT o) {
                UnsafeMemoryOutput out = new UnsafeMemoryOutput(Buffer.SMALL_BUFFER_SIZE, Buffer.MAX_BUFFER_SIZE);
                engine.writeObject(out, o);
                out.flush();
                return out.toBytes();
            }
        };
    }
}

