/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.api.LocalCachedMapOptions;
import org.redisson.spring.support.RedissonNamespaceDecorator;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocalCachedMapOptionsDecorator
implements RedissonNamespaceDecorator {
    @Override
    public void decorate(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, RedissonNamespaceParserSupport helper) {
        String id;
        NodeList list = element.getElementsByTagNameNS("http://redisson.org/schema/redisson", "local-cached-map-options");
        Element options = null;
        if (list.getLength() == 1) {
            options = (Element)list.item(0);
            id = this.invokeOptions(options, parserContext, helper);
            for (int i = 0; i < options.getAttributes().getLength(); ++i) {
                Attr item = (Attr)options.getAttributes().item(i);
                if (!helper.isEligibleAttribute(item) || "time-to-live-unit".equals(item.getLocalName()) || "max-idle-unit".equals(item.getLocalName())) continue;
                helper.invoker(id, helper.getName(item), new Object[]{item.getValue()}, parserContext);
            }
            this.invokeTimeUnitOptions(options, id, parserContext, helper, "time-to-live", "time-to-live-unit");
            this.invokeTimeUnitOptions(options, id, parserContext, helper, "max-idle", "max-idle-unit");
        } else {
            id = this.invokeOptions(options, parserContext, helper);
        }
        helper.addConstructorArgs((Object)new RuntimeBeanReference(id), LocalCachedMapOptions.class, builder);
    }

    private String invokeOptions(Element element, ParserContext parserContext, RedissonNamespaceParserSupport helper) {
        BeanComponentDefinition defaultOption = helper.factoryInvoker(element, LocalCachedMapOptions.class, "defaults", null, parserContext);
        return defaultOption.getName();
    }

    private void invokeTimeUnitOptions(Element element, String id, ParserContext parserContext, RedissonNamespaceParserSupport helper, String timeAttrubute, String timeUnitAttribute) {
        if (helper.hasAttribute(element, timeUnitAttribute)) {
            Assert.state((boolean)helper.hasAttribute(element, timeAttrubute), (String)("Missing \"" + timeAttrubute + "\" attribute in \"" + "local-cached-map-options" + "\" element."));
            helper.invoker(id, Conventions.attributeNameToPropertyName((String)timeAttrubute), new Object[]{Integer.parseInt(helper.getAttribute(element, timeAttrubute)), helper.getAttribute(element, timeUnitAttribute)}, parserContext);
        }
    }
}

