/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.compression.Snappy;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.FstCodec;

public class SnappyCodec
implements Codec {
    private static final ThreadLocal<Snappy> snappyDecoder = new ThreadLocal<Snappy>(){

        @Override
        protected Snappy initialValue() {
            return new Snappy();
        }
    };
    private static final ThreadLocal<Snappy> snappyEncoder = new ThreadLocal<Snappy>(){

        @Override
        protected Snappy initialValue() {
            return new Snappy();
        }
    };
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ((Snappy)snappyDecoder.get()).decode(buf, out);
                Object object = SnappyCodec.this.innerCodec.getValueDecoder().decode(out, state);
                return object;
            }
            finally {
                ((Snappy)snappyDecoder.get()).reset();
                out.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf buf = SnappyCodec.this.innerCodec.getValueEncoder().encode(in);
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(buf.readableBytes() + 128);
            try {
                ((Snappy)snappyEncoder.get()).encode(buf, out, buf.readableBytes());
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            finally {
                buf.release();
                ((Snappy)snappyEncoder.get()).reset();
            }
        }
    };

    public SnappyCodec() {
        this(new FstCodec());
    }

    public SnappyCodec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public SnappyCodec(ClassLoader classLoader) {
        this(new FstCodec(classLoader));
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

