/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;

public abstract class RedissonBaseMapIterator<K, V, M>
implements Iterator<M> {
    private Map<ByteBuf, ByteBuf> firstValues;
    private Map<ByteBuf, ByteBuf> lastValues;
    private Iterator<Map.Entry<ScanObjectEntry, ScanObjectEntry>> lastIter;
    protected long nextIterPos;
    protected InetSocketAddress client;
    private boolean finished;
    private boolean currentElementRemoved;
    protected Map.Entry<ScanObjectEntry, ScanObjectEntry> entry;

    @Override
    public boolean hasNext() {
        if (this.lastIter == null || !this.lastIter.hasNext()) {
            if (this.finished) {
                this.free(this.firstValues);
                this.free(this.lastValues);
                this.currentElementRemoved = false;
                this.client = null;
                this.firstValues = null;
                this.lastValues = null;
                this.nextIterPos = 0L;
                if (!this.tryAgain()) {
                    return false;
                }
                this.finished = false;
            }
            do {
                MapScanResult<ScanObjectEntry, ScanObjectEntry> res = this.iterator();
                if (this.lastValues != null) {
                    this.free(this.lastValues);
                }
                this.lastValues = this.convert(res.getMap());
                this.client = res.getRedisClient();
                if (this.nextIterPos == 0L && this.firstValues == null) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty() && this.tryAgain()) {
                        this.client = null;
                        this.firstValues = null;
                        this.nextIterPos = 0L;
                    }
                } else if (this.firstValues.isEmpty()) {
                    this.firstValues = this.lastValues;
                    this.lastValues = null;
                    if (this.firstValues.isEmpty()) {
                        if (this.tryAgain()) {
                            this.client = null;
                            this.firstValues = null;
                            this.nextIterPos = 0L;
                            continue;
                        }
                        if (res.getPos() == 0L) {
                            this.free(this.firstValues);
                            this.free(this.lastValues);
                            this.finished = true;
                            return false;
                        }
                    }
                } else if (this.lastValues.keySet().removeAll(this.firstValues.keySet()) || this.lastValues.isEmpty() && this.nextIterPos == 0L) {
                    this.free(this.firstValues);
                    this.free(this.lastValues);
                    this.currentElementRemoved = false;
                    this.client = null;
                    this.firstValues = null;
                    this.lastValues = null;
                    this.nextIterPos = 0L;
                    if (this.tryAgain()) continue;
                    this.finished = true;
                    return false;
                }
                this.lastIter = res.getMap().entrySet().iterator();
                this.nextIterPos = res.getPos();
            } while (!this.lastIter.hasNext());
        }
        return this.lastIter.hasNext();
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract MapScanResult<ScanObjectEntry, ScanObjectEntry> iterator();

    private void free(Map<ByteBuf, ByteBuf> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<ByteBuf, ByteBuf> entry : map.entrySet()) {
            entry.getKey().release();
            entry.getValue().release();
        }
    }

    private Map<ByteBuf, ByteBuf> convert(Map<ScanObjectEntry, ScanObjectEntry> map) {
        HashMap<ByteBuf, ByteBuf> result = new HashMap<ByteBuf, ByteBuf>(map.size());
        for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : map.entrySet()) {
            result.put(entry.getKey().getBuf(), entry.getValue().getBuf());
        }
        return result;
    }

    @Override
    public M next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.entry = this.lastIter.next();
        this.currentElementRemoved = false;
        return this.getValue(this.entry);
    }

    protected M getValue(final Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey().getObj(), entry.getValue().getObj()){

            @Override
            public V setValue(V value) {
                return RedissonBaseMapIterator.this.put(entry, value);
            }
        };
    }

    @Override
    public void remove() {
        if (this.currentElementRemoved) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.lastIter == null || this.entry == null) {
            throw new IllegalStateException();
        }
        this.firstValues.remove(this.entry.getKey().getBuf());
        this.lastIter.remove();
        this.removeKey();
        this.currentElementRemoved = true;
        this.entry = null;
    }

    protected abstract void removeKey();

    protected abstract V put(Map.Entry<ScanObjectEntry, ScanObjectEntry> var1, V var2);
}

