/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.tuple;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.fn.tuple.Tuple1;

public class Tuple2<T1, T2>
extends Tuple1<T1> {
    private static final long serialVersionUID = -565933838909569191L;
    public final T2 t2;

    Tuple2(int size, T1 t1, T2 t2) {
        super(size, t1);
        this.t2 = t2;
    }

    public T2 getT2() {
        return this.t2;
    }

    @Override
    @Nullable
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.t1;
            }
            case 1: {
                return this.t2;
            }
        }
        return null;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.t1, this.t2};
    }

    @Override
    @Nonnull
    public Iterator<?> iterator() {
        return Arrays.asList(this.t1, this.t2).iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple2)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Tuple2 tuple2 = (Tuple2)o;
        return !(this.t2 != null ? !this.t2.equals(tuple2.t2) : tuple2.t2 != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.t2 != null ? this.t2.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + (this.t2 != null ? "," + this.t2.toString() : "");
    }
}

