/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.executor.TasksService;
import org.redisson.remote.RemoteServiceRequest;

public class ScheduledTasksService
extends TasksService {
    private String requestId;
    private String schedulerQueueName;
    private String schedulerChannelName;

    public ScheduledTasksService(Codec codec, RedissonClient redisson, String name, CommandExecutor commandExecutor) {
        super(codec, redisson, name, commandExecutor);
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setSchedulerQueueName(String scheduledQueueName) {
        this.schedulerQueueName = scheduledQueueName;
    }

    @Override
    protected RFuture<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request) {
        Long startTime = (Long)request.getArgs()[3];
        ByteBuf encodedRequest = this.encode(request);
        if (this.requestId != null) {
            return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 and redis.call('hexists', KEYS[5], ARGV[2]) == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[2]);redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('incr', KEYS[1]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName), startTime, request.getRequestId(), encodedRequest);
        }
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[2]);redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('incr', KEYS[1]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName), startTime, request.getRequestId(), encodedRequest);
    }

    @Override
    protected void awaitResultAsync(final RemoteInvocationOptions optionsCopy, final RemotePromise<Object> result, final RemoteServiceRequest request, final String responseName) {
        long delay;
        if (!optionsCopy.isResultExpected()) {
            return;
        }
        Long startTime = 0L;
        if (request != null && request.getArgs() != null && request.getArgs().length > 3) {
            startTime = (Long)request.getArgs()[3];
        }
        if ((delay = startTime - System.currentTimeMillis()) > 0L) {
            this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    ScheduledTasksService.super.awaitResultAsync(optionsCopy, result, request, responseName);
                }
            }, delay, TimeUnit.MILLISECONDS);
        } else {
            super.awaitResultAsync(optionsCopy, result, request, responseName);
        }
    }

    @Override
    protected RFuture<Boolean> removeAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('zrem', KEYS[2], ARGV[1]) > 0 then redis.call('hdel', KEYS[6], ARGV[1]); if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;local task = redis.call('hget', KEYS[6], ARGV[1]); if task ~= false and redis.call('lrem', KEYS[1], 1, task) > 0 then redis.call('hdel', KEYS[6], ARGV[1]); if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;redis.call('hdel', KEYS[6], ARGV[1]); return 0;", Arrays.asList(requestQueue.getName(), this.schedulerQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName), request.getRequestId(), 1, 2);
    }

    @Override
    protected String generateRequestId() {
        if (this.requestId == null) {
            return super.generateRequestId();
        }
        return this.requestId;
    }
}

