/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.command.CommandReactiveService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.redisson.reactive.NettyFuturePublisher;
import reactor.fn.Supplier;
import reactor.rx.action.support.DefaultSubscriber;

public class CommandReactiveBatchService
extends CommandReactiveService {
    private final CommandBatchService batchService;
    private final Queue<Publisher<?>> publishers = new ConcurrentLinkedQueue();

    public CommandReactiveBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
        this.batchService = new CommandBatchService(connectionManager);
    }

    @Override
    public <R> Publisher<R> reactive(Supplier<RFuture<R>> supplier) {
        NettyFuturePublisher publisher = new NettyFuturePublisher(supplier);
        this.publishers.add(publisher);
        return publisher;
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, attempt);
    }

    public List<?> execute() {
        return this.get(this.executeAsync(0L, 0, 0L));
    }

    public List<?> execute(long responseTimeout, int retryAttempts, long retryInterval) {
        return this.get(this.executeAsync(responseTimeout, retryAttempts, retryInterval));
    }

    public RFuture<Void> executeAsyncVoid() {
        return this.executeAsyncVoid(false, 0L, 0, 0L);
    }

    private RFuture<Void> executeAsyncVoid(boolean noResult, long responseTimeout, int retryAttempts, long retryInterval) {
        for (Publisher publisher : this.publishers) {
            publisher.subscribe(new DefaultSubscriber<Object>(){

                @Override
                public void onSubscribe(Subscription s) {
                    s.request(1L);
                }
            });
        }
        return this.batchService.executeAsyncVoid(noResult, responseTimeout, retryAttempts, retryInterval);
    }

    public void executeSkipResult(long timeout, int retryAttempts, long retryInterval) {
        this.get(this.executeSkipResultAsync(timeout, retryAttempts, retryInterval));
    }

    public RFuture<Void> executeSkipResultAsync(long timeout, int retryAttempts, long retryInterval) {
        return this.executeAsyncVoid(true, timeout, retryAttempts, retryInterval);
    }

    public RFuture<List<?>> executeAsync() {
        return this.executeAsync(0L, 0, 0L);
    }

    public RFuture<List<?>> executeAsync(long responseTimeout, int retryAttempts, long retryInterval) {
        for (Publisher publisher : this.publishers) {
            publisher.subscribe(new DefaultSubscriber<Object>(){

                @Override
                public void onSubscribe(Subscription s) {
                    s.request(1L);
                }
            });
        }
        return this.batchService.executeAsync(responseTimeout, retryAttempts, retryInterval);
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        this.batchService.enableRedissonReferenceSupport(redissonReactive);
        return super.enableRedissonReferenceSupport(redissonReactive);
    }
}

