/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final AtomicLong index = new AtomicLong();
    private final List<Collection<CachedValue<K, V>>> queues = new ArrayList<Collection<CachedValue<K, V>>>(Runtime.getRuntime().availableProcessors() * 2);

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2; ++i) {
            Set instance = Collections.synchronizedSet(new LinkedHashSet());
            this.queues.add(instance);
        }
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        queue.add(value);
    }

    private Collection<CachedValue<K, V>> getQueue(CachedValue<K, V> value) {
        return this.queues.get(value.hashCode() % this.queues.size());
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        queue.remove(value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        if (queue.remove(value)) {
            queue.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMapFull() {
        int startIndex = -1;
        int queueIndex;
        while ((queueIndex = (int)Math.abs(this.index.incrementAndGet() % (long)this.queues.size())) != startIndex) {
            Collection<CachedValue<K, V>> queue;
            if (startIndex == -1) {
                startIndex = queueIndex;
            }
            Collection<CachedValue<K, V>> collection = queue = this.queues.get(queueIndex);
            synchronized (collection) {
                Iterator<CachedValue<K, V>> iter = queue.iterator();
                if (iter.hasNext()) {
                    CachedValue<K, V> value = iter.next();
                    iter.remove();
                    this.map.remove(value.getKey(), value);
                    return;
                }
            }
        }
        return;
    }

    @Override
    public void clear() {
        for (Collection<CachedValue<K, V>> collection : this.queues) {
            collection.clear();
        }
        super.clear();
    }
}

