/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.api.annotation.RRemoteAsync;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceAckTimeoutException;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RemoteServiceResponse;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRemoteService {
    private static final Logger log = LoggerFactory.getLogger(BaseRemoteService.class);
    protected final Codec codec;
    protected final RedissonClient redisson;
    protected final String name;
    protected final CommandAsyncExecutor commandExecutor;

    public BaseRemoteService(RedissonClient redisson, CommandAsyncExecutor commandExecutor) {
        this(redisson, "redisson_rs", commandExecutor);
    }

    public BaseRemoteService(RedissonClient redisson, String name, CommandAsyncExecutor commandExecutor) {
        this(null, redisson, name, commandExecutor);
    }

    public BaseRemoteService(Codec codec, RedissonClient redisson, CommandAsyncExecutor commandExecutor) {
        this(codec, redisson, "redisson_rs", commandExecutor);
    }

    public BaseRemoteService(Codec codec, RedissonClient redisson, String name, CommandAsyncExecutor commandExecutor) {
        this.codec = codec;
        this.redisson = redisson;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    protected String getCancelRequestQueueName(Class<?> remoteInterface, String requestId) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}:" + requestId + ":cancel";
    }

    protected String getAckName(Class<?> remoteInterface, String requestId) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}:" + requestId + ":ack";
    }

    protected String getResponseQueueName(Class<?> remoteInterface, String requestId) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}:" + requestId;
    }

    protected String getRequestQueueName(Class<?> remoteInterface) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}";
    }

    protected Codec getCodec() {
        if (this.codec != null) {
            return this.codec;
        }
        return this.redisson.getConfig().getCodec();
    }

    protected ByteBuf encode(Object obj) {
        try {
            return this.getCodec().getValueEncoder().encode(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T get(Class<T> remoteInterface) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults());
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit, long ackTimeout, TimeUnit ackTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectAckWithin(ackTimeout, ackTimeUnit).expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, RemoteInvocationOptions options) {
        for (Annotation annotation : remoteInterface.getAnnotations()) {
            if (annotation.annotationType() != RRemoteAsync.class) continue;
            Class<?> syncInterface = ((RRemoteAsync)annotation).value();
            for (Method m : remoteInterface.getMethods()) {
                try {
                    syncInterface.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Method '" + m.getName() + "' with params '" + Arrays.toString(m.getParameterTypes()) + "' isn't defined in " + syncInterface);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException(e);
                }
                if (m.getReturnType().getClass().isInstance(RFuture.class)) continue;
                throw new IllegalArgumentException(m.getReturnType().getClass() + " isn't allowed as return type");
            }
            return this.async(remoteInterface, options, syncInterface);
        }
        return this.sync(remoteInterface, options);
    }

    private <T> T async(Class<T> remoteInterface, RemoteInvocationOptions options, final Class<?> syncInterface) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(RFuture.class))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                final String requestId = BaseRemoteService.this.generateRequestId();
                final String requestQueueName = BaseRemoteService.this.getRequestQueueName(syncInterface);
                final String responseName = BaseRemoteService.this.getResponseQueueName(syncInterface, requestId);
                final String ackName = BaseRemoteService.this.getAckName(syncInterface, requestId);
                final RBlockingQueue<RemoteServiceRequest> requestQueue = BaseRemoteService.this.redisson.getBlockingQueue(requestQueueName, BaseRemoteService.this.getCodec());
                final RemoteServiceRequest request = new RemoteServiceRequest(requestId, method.getName(), BaseRemoteService.this.getMethodSignatures(method), args, optionsCopy, System.currentTimeMillis());
                final RemotePromise<Object> result = new RemotePromise<Object>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        if (this.isCancelled()) {
                            return true;
                        }
                        if (this.isDone()) {
                            return false;
                        }
                        if (optionsCopy.isAckExpected()) {
                            RFuture future = BaseRemoteService.this.commandExecutor.evalWriteAsync(responseName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]);redis.call('lrem', KEYS[3], 1, ARGV[1]);redis.call('pexpire', KEYS[2], ARGV[2]);return 1;end;return 0;", Arrays.asList(ackName, responseName, requestQueueName), BaseRemoteService.this.encode(request), request.getOptions().getAckTimeoutInMillis());
                            boolean ackNotSent = (Boolean)BaseRemoteService.this.commandExecutor.get(future);
                            if (ackNotSent) {
                                super.cancel(mayInterruptIfRunning);
                                return true;
                            }
                            return this.cancel(syncInterface, requestId, request, mayInterruptIfRunning);
                        }
                        boolean removed = BaseRemoteService.this.commandExecutor.get(BaseRemoteService.this.removeAsync(requestQueue, request));
                        if (removed) {
                            super.cancel(mayInterruptIfRunning);
                            return true;
                        }
                        return this.cancel(syncInterface, requestId, request, mayInterruptIfRunning);
                    }

                    private boolean cancel(Class<?> remoteInterface, String requestId2, RemoteServiceRequest request2, boolean mayInterruptIfRunning) {
                        if (this.isCancelled()) {
                            return true;
                        }
                        if (this.isDone()) {
                            return false;
                        }
                        String canceRequestName = BaseRemoteService.this.getCancelRequestQueueName(remoteInterface, requestId2);
                        BaseRemoteService.this.cancelExecution(optionsCopy, responseName, request2, mayInterruptIfRunning, canceRequestName, this);
                        this.awaitUninterruptibly(60L, TimeUnit.SECONDS);
                        return this.isCancelled();
                    }
                };
                result.setRequestId(requestId);
                RFuture<Boolean> addFuture = BaseRemoteService.this.addAsync(requestQueue, request, result);
                addFuture.addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (optionsCopy.isAckExpected()) {
                            final RBlockingQueue responseQueue = BaseRemoteService.this.redisson.getBlockingQueue(responseName, BaseRemoteService.this.getCodec());
                            RFuture<RemoteServiceAck> ackFuture = responseQueue.pollAsync(optionsCopy.getAckTimeoutInMillis(), TimeUnit.MILLISECONDS);
                            ackFuture.addListener(new FutureListener<RemoteServiceAck>(){

                                @Override
                                public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        result.tryFailure(future.cause());
                                        return;
                                    }
                                    RemoteServiceAck ack = future.getNow();
                                    if (ack == null) {
                                        RFuture ackFutureAttempt = BaseRemoteService.this.tryPollAckAgainAsync(optionsCopy, responseQueue, ackName);
                                        ackFutureAttempt.addListener(new FutureListener<RemoteServiceAck>(){

                                            @Override
                                            public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                                if (!future.isSuccess()) {
                                                    result.tryFailure(future.cause());
                                                    return;
                                                }
                                                if (future.getNow() == null) {
                                                    RemoteServiceAckTimeoutException ex = new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                                                    result.tryFailure(ex);
                                                    return;
                                                }
                                                BaseRemoteService.this.awaitResultAsync(optionsCopy, result, request, responseName, ackName);
                                            }
                                        });
                                    } else {
                                        BaseRemoteService.this.awaitResultAsync(optionsCopy, result, request, responseName);
                                    }
                                }
                            });
                        } else {
                            BaseRemoteService.this.awaitResultAsync(optionsCopy, result, request, responseName);
                        }
                    }
                });
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private void awaitResultAsync(final RemoteInvocationOptions optionsCopy, final RemotePromise<Object> result, final RemoteServiceRequest request, final String responseName, String ackName) {
        RFuture<Boolean> deleteFuture = this.redisson.getBucket(ackName).deleteAsync();
        deleteFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                BaseRemoteService.this.awaitResultAsync(optionsCopy, result, request, responseName);
            }
        });
    }

    protected void awaitResultAsync(final RemoteInvocationOptions optionsCopy, final RemotePromise<Object> result, final RemoteServiceRequest request, String responseName) {
        if (!optionsCopy.isResultExpected()) {
            return;
        }
        RBlockingQueue responseQueue = this.redisson.getBlockingQueue(responseName, this.getCodec());
        RFuture<RRemoteServiceResponse> responseFuture = responseQueue.pollAsync(optionsCopy.getExecutionTimeoutInMillis(), TimeUnit.MILLISECONDS);
        responseFuture.addListener(new FutureListener<RRemoteServiceResponse>(){

            @Override
            public void operationComplete(Future<RRemoteServiceResponse> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow() == null) {
                    RemoteServiceTimeoutException e = new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                    result.tryFailure(e);
                    return;
                }
                if (future.getNow() instanceof RemoteServiceCancelResponse) {
                    result.doCancel();
                    return;
                }
                RemoteServiceResponse response = (RemoteServiceResponse)future.getNow();
                if (response.getError() != null) {
                    result.tryFailure(response.getError());
                    return;
                }
                result.trySuccess(response.getResult());
            }
        });
    }

    private <T> T sync(final Class<T> remoteInterface, RemoteInvocationOptions options) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                String requestId = BaseRemoteService.this.generateRequestId();
                String requestQueueName = BaseRemoteService.this.getRequestQueueName(remoteInterface);
                RBlockingQueue requestQueue = BaseRemoteService.this.redisson.getBlockingQueue(requestQueueName, BaseRemoteService.this.getCodec());
                RemoteServiceRequest request = new RemoteServiceRequest(requestId, method.getName(), BaseRemoteService.this.getMethodSignatures(method), args, optionsCopy, System.currentTimeMillis());
                requestQueue.add(request);
                RBlockingQueue responseQueue = null;
                if (optionsCopy.isAckExpected() || optionsCopy.isResultExpected()) {
                    String responseName = BaseRemoteService.this.getResponseQueueName(remoteInterface, requestId);
                    responseQueue = BaseRemoteService.this.redisson.getBlockingQueue(responseName, BaseRemoteService.this.getCodec());
                }
                if (optionsCopy.isAckExpected()) {
                    String ackName = BaseRemoteService.this.getAckName(remoteInterface, requestId);
                    RemoteServiceAck ack = (RemoteServiceAck)responseQueue.poll(optionsCopy.getAckTimeoutInMillis(), TimeUnit.MILLISECONDS);
                    if (ack == null && (ack = BaseRemoteService.this.tryPollAckAgain(optionsCopy, responseQueue, ackName)) == null) {
                        throw new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                    }
                    BaseRemoteService.this.redisson.getBucket(ackName).delete();
                }
                if (optionsCopy.isResultExpected()) {
                    RemoteServiceResponse response = (RemoteServiceResponse)responseQueue.poll(optionsCopy.getExecutionTimeoutInMillis(), TimeUnit.MILLISECONDS);
                    if (response == null) {
                        throw new RemoteServiceTimeoutException("No response1 after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                    }
                    if (response.getError() != null) {
                        throw response.getError();
                    }
                    return response.getResult();
                }
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private RemoteServiceAck tryPollAckAgain(RemoteInvocationOptions optionsCopy, RBlockingQueue<? extends RRemoteServiceResponse> responseQueue, String ackName) throws InterruptedException {
        RFuture ackClientsFuture = this.commandExecutor.evalWriteAsync(ackName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.sync();
        if (((Boolean)ackClientsFuture.getNow()).booleanValue()) {
            return (RemoteServiceAck)responseQueue.poll();
        }
        return null;
    }

    private RFuture<RemoteServiceAck> tryPollAckAgainAsync(RemoteInvocationOptions optionsCopy, final RBlockingQueue<RemoteServiceAck> responseQueue, String ackName) throws InterruptedException {
        final RedissonPromise<RemoteServiceAck> promise = new RedissonPromise<RemoteServiceAck>();
        RFuture ackClientsFuture = this.commandExecutor.evalWriteAsync(ackName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RFuture<RemoteServiceAck> pollFuture = responseQueue.pollAsync();
                    pollFuture.addListener(new FutureListener<RemoteServiceAck>(){

                        @Override
                        public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            promise.trySuccess(future.getNow());
                        }
                    });
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    protected String generateRequestId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    protected RFuture<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request, RemotePromise<Object> result) {
        RFuture<Boolean> future = requestQueue.addAsync(request);
        result.setAddFuture(future);
        return future;
    }

    protected RFuture<Boolean> removeAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request) {
        return requestQueue.removeAsync(request);
    }

    private void cancelExecution(RemoteInvocationOptions optionsCopy, String responseName, RemoteServiceRequest request, boolean mayInterruptIfRunning, String canceRequestName, RemotePromise<Object> remotePromise) {
        RBlockingQueue<RemoteServiceCancelRequest> cancelRequestQueue = this.redisson.getBlockingQueue(canceRequestName, this.getCodec());
        cancelRequestQueue.putAsync(new RemoteServiceCancelRequest(mayInterruptIfRunning));
        cancelRequestQueue.expireAsync(60L, TimeUnit.SECONDS);
        if (!optionsCopy.isResultExpected()) {
            RemoteInvocationOptions options = new RemoteInvocationOptions(optionsCopy);
            options.expectResultWithin(60L, TimeUnit.SECONDS);
            this.awaitResultAsync(options, remotePromise, request, responseName);
        }
    }

    protected List<String> getMethodSignatures(Method method) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class<?> t : method.getParameterTypes()) {
            list.add(t.getName());
        }
        return list;
    }
}

