/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.BatchService;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.rx.CommandRxService;

public class CommandRxBatchService
extends CommandRxService
implements BatchService {
    private final CommandBatchService batchService;

    CommandRxBatchService(ConnectionManager connectionManager, CommandAsyncExecutor executor, BatchOptions options) {
        super(connectionManager, executor.getObjectBuilder());
        this.batchService = new CommandBatchService(executor, options, RedissonObjectBuilder.ReferenceType.RXJAVA);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<RFuture<R>> supplier) {
        Flowable flowable = super.flowable(new Callable<RFuture<R>>(){
            final CompletableFuture<R> future = new CompletableFuture();
            final AtomicBoolean lock = new AtomicBoolean();

            @Override
            public RFuture<R> call() throws Exception {
                if (this.lock.compareAndSet(false, true)) {
                    CommandRxBatchService.this.transfer(((RFuture)supplier.call()).toCompletableFuture(), this.future);
                }
                return new CompletableFutureWrapper(this.future);
            }
        });
        flowable.subscribe();
        return flowable;
    }

    @Override
    protected <R> CompletableFuture<R> createPromise() {
        return this.batchService.createPromise();
    }

    @Override
    public <V, R> RFuture<R> async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, boolean ignoreRedirect, boolean noRetry) {
        return this.batchService.async(readOnlyMode, nodeSource, codec, command, params, ignoreRedirect, noRetry);
    }

    public RFuture<BatchResult<?>> executeAsync() {
        return this.batchService.executeAsync();
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    public RFuture<Void> discardAsync() {
        return this.batchService.discardAsync();
    }
}

