/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsCnameCache;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import org.redisson.connection.AddressResolverGroupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinDnsAddressResolverGroupFactory
implements AddressResolverGroupFactory {
    static final Logger log = LoggerFactory.getLogger(RoundRobinDnsAddressResolverGroupFactory.class);

    public DnsAddressResolverGroup create(Class<? extends DatagramChannel> channelType, Class<? extends SocketChannel> socketChannelType, DnsServerAddressStreamProvider nameServerProvider) {
        DnsNameResolverBuilder dnsResolverBuilder = new DnsNameResolverBuilder();
        try {
            dnsResolverBuilder.getClass().getMethod("socketChannelType", Class.class, Boolean.TYPE);
            dnsResolverBuilder.socketChannelType(socketChannelType, true);
        }
        catch (NoSuchMethodException e) {
            log.warn("DNS TCP fallback on UDP query timeout disabled. Upgrade Netty to 4.1.105 or higher.");
            dnsResolverBuilder.socketChannelType(socketChannelType);
        }
        dnsResolverBuilder.channelType(channelType).nameServerProvider(nameServerProvider).resolveCache(new DefaultDnsCache()).cnameCache(new DefaultDnsCnameCache());
        return new RoundRobinDnsAddressResolverGroup(dnsResolverBuilder);
    }
}

