/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.QueueTransferTask;

public class QueueTransferService {
    private final Map<String, QueueTransferTask> tasks = new ConcurrentHashMap<String, QueueTransferTask>();

    public void schedule(String name, QueueTransferTask task) {
        this.tasks.compute(name, (k, t) -> {
            if (t == null) {
                task.start();
                return task;
            }
            t.incUsage();
            return t;
        });
    }

    public void remove(String name) {
        AtomicReference ref = new AtomicReference();
        this.tasks.compute(name, (k, task) -> {
            if (task == null) {
                return null;
            }
            if (task.decUsage() == 0) {
                ref.set(task);
                return null;
            }
            return task;
        });
        if (ref.get() != null) {
            ((QueueTransferTask)ref.get()).stop();
        }
    }
}

