/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBucket;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketTrySetOperation<V>
extends TransactionalOperation {
    private String transactionId;
    private Object value;
    private String lockName;
    private long timeToLive;
    private TimeUnit timeUnit;

    public BucketTrySetOperation(String name, String lockName, Codec codec, Object value, long timeToLive, TimeUnit timeUnit, String transactionId, long threadId) {
        this(name, lockName, codec, value, transactionId, threadId);
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
    }

    public BucketTrySetOperation(String name, String lockName, Codec codec, Object value, String transactionId, long threadId) {
        super(name, codec, threadId);
        this.value = value;
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<Object> bucket = new RedissonBucket<Object>(this.codec, commandExecutor, this.name);
        if (this.timeToLive != 0L) {
            bucket.trySetAsync(this.value, this.timeToLive, this.timeUnit);
        } else {
            bucket.trySetAsync(this.value);
        }
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync(this.getThreadId());
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync(this.getThreadId());
    }

    public Object getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

