/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;

public class JCacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private static final long serialVersionUID = -4601376694286796662L;
    private final Object key;
    private final Object value;
    private final Object oldValue;

    public JCacheEntryEvent(Cache<K, V> source, EventType eventType, Object key, Object value) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = null;
    }

    public JCacheEntryEvent(Cache<K, V> source, EventType eventType, Object key, Object value, Object oldValue) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
    }

    @Override
    public K getKey() {
        return (K)this.key;
    }

    @Override
    public V getValue() {
        return (V)this.value;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public V getOldValue() {
        return (V)this.oldValue;
    }

    @Override
    public boolean isOldValueAvailable() {
        return this.oldValue != null;
    }
}

