/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.ClusterConnectionManager;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.ReplicatedConnectionManager;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.connection.ServiceManager;
import org.redisson.connection.SingleConnectionManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.RedisURI;
import org.redisson.pubsub.PublishSubscribeService;

public interface ConnectionManager {
    public void connect();

    public PublishSubscribeService getSubscribeService();

    public RedisURI getLastClusterNode();

    public int calcSlot(String var1);

    public int calcSlot(ByteBuf var1);

    public int calcSlot(byte[] var1);

    public Collection<MasterSlaveEntry> getEntrySet();

    public MasterSlaveEntry getEntry(String var1);

    public MasterSlaveEntry getEntry(int var1);

    public MasterSlaveEntry getWriteEntry(int var1);

    public MasterSlaveEntry getReadEntry(int var1);

    public MasterSlaveEntry getEntry(InetSocketAddress var1);

    public MasterSlaveEntry getEntry(RedisURI var1);

    public RedisClient createClient(NodeType var1, InetSocketAddress var2, RedisURI var3, String var4);

    public RedisClient createClient(NodeType var1, RedisURI var2, String var3);

    public MasterSlaveEntry getEntry(RedisClient var1);

    public void shutdown();

    public void shutdown(long var1, long var3, TimeUnit var5);

    public ServiceManager getServiceManager();

    public CommandAsyncExecutor createCommandExecutor(RedissonObjectBuilder var1, RedissonObjectBuilder.ReferenceType var2);

    public static ConnectionManager create(Config configCopy) {
        BaseConfig<?> cfg = ConfigSupport.getConfig(configCopy);
        MasterSlaveConnectionManager cm = null;
        if (cfg instanceof MasterSlaveServersConfig) {
            cm = new MasterSlaveConnectionManager((MasterSlaveServersConfig)cfg, configCopy);
        } else if (cfg instanceof SingleServerConfig) {
            cm = new SingleConnectionManager((SingleServerConfig)cfg, configCopy);
        } else if (cfg instanceof SentinelServersConfig) {
            cm = new SentinelConnectionManager((SentinelServersConfig)cfg, configCopy);
        } else if (cfg instanceof ClusterServersConfig) {
            cm = new ClusterConnectionManager((ClusterServersConfig)cfg, configCopy);
        } else if (cfg instanceof ReplicatedServersConfig) {
            cm = new ReplicatedConnectionManager((ReplicatedServersConfig)cfg, configCopy);
        }
        if (cm == null) {
            throw new IllegalArgumentException("server(s) address(es) not defined!");
        }
        if (!configCopy.isLazyInitialization()) {
            cm.connect();
        }
        return cm;
    }
}

