/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import org.redisson.api.RFuture;
import org.redisson.api.options.ObjectParams;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.reactive.CommandReactiveExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CommandReactiveService
extends CommandAsyncService
implements CommandReactiveExecutor {
    CommandReactiveService(CommandAsyncExecutor executor, boolean trackChanges) {
        super(executor, trackChanges);
    }

    CommandReactiveService(ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder) {
        super(connectionManager, objectBuilder, RedissonObjectBuilder.ReferenceType.REACTIVE);
    }

    CommandReactiveService(CommandAsyncExecutor executor, ObjectParams objectParams) {
        super(executor, objectParams);
    }

    @Override
    public CommandReactiveExecutor copy(boolean trackChanges) {
        return new CommandReactiveService((CommandAsyncExecutor)this, trackChanges);
    }

    @Override
    public CommandReactiveExecutor copy(ObjectParams objectParams) {
        return new CommandReactiveService((CommandAsyncExecutor)this, objectParams);
    }

    @Override
    public <R> Mono<R> reactive(Callable<RFuture<R>> supplier) {
        return Flux.create(emitter -> emitter.onRequest(n -> {
            RFuture future;
            try {
                future = (RFuture)supplier.call();
            }
            catch (Exception e2) {
                emitter.error(e2);
                return;
            }
            emitter.onDispose(() -> future.cancel(true));
            future.whenComplete((v, e) -> {
                if (e != null) {
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    emitter.error((Throwable)e);
                    return;
                }
                if (v != null) {
                    emitter.next(v);
                }
                emitter.complete();
            });
        })).next();
    }
}

