/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;
import org.redisson.misc.RedisURI;

public class CommandsLoadBalancer
extends RoundRobinLoadBalancer
implements LoadBalancer {
    private Set<String> commands;
    private RedisURI address;

    @Override
    public ClientConnectionsEntry getEntry(List<ClientConnectionsEntry> clientsCopy, RedisCommand<?> redisCommand) {
        if (this.commands.contains(redisCommand.getName().toLowerCase(Locale.ENGLISH))) {
            return clientsCopy.stream().filter(c -> this.address.equals(c.getClient().getAddr())).findAny().orElseGet(() -> this.getEntry(clientsCopy));
        }
        return this.getEntry(clientsCopy);
    }

    public void setAddress(String address) {
        this.address = new RedisURI(address);
    }

    public void setCommands(List<String> commands) {
        this.commands = commands.stream().map(c -> c.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
    }
}

