/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapEntriesDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonRateLimiter
extends RedissonExpirable
implements RRateLimiter {
    private static final RedisCommand HGETALL = new RedisCommand<Object>("HGETALL", new MapEntriesDecoder((MultiDecoder<Object>)new MultiDecoder<RateLimiterConfig>(){

        @Override
        public RateLimiterConfig decode(List<Object> parts, State state) {
            HashMap<String, String> map = new HashMap<String, String>(parts.size() / 2);
            for (int i = 0; i < parts.size(); ++i) {
                if (i % 2 == 0) continue;
                map.put(parts.get(i - 1).toString(), parts.get(i).toString());
            }
            if (map.size() == 0) {
                return new RateLimiterConfig(RateType.OVERALL, 0L, 0L);
            }
            RateType type = RateType.values()[Integer.parseInt((String)map.get("type"))];
            Long rateInterval = Long.valueOf((String)map.get("interval"));
            Long rate = Long.valueOf((String)map.get("rate"));
            return new RateLimiterConfig(type, rateInterval, rate);
        }
    }));

    public RedissonRateLimiter(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    String getPermitsName() {
        return RedissonRateLimiter.suffixName(this.getRawName(), "permits");
    }

    String getClientPermitsName() {
        return RedissonRateLimiter.suffixName(this.getPermitsName(), this.getServiceManager().getId());
    }

    String getValueName() {
        return RedissonRateLimiter.suffixName(this.getRawName(), "value");
    }

    String getClientValueName() {
        return RedissonRateLimiter.suffixName(this.getValueName(), this.getServiceManager().getId());
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1L);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1L);
    }

    @Override
    public boolean tryAcquire(long permits) {
        return this.get(this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, (Long)permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits) {
        return this.tryAcquireAsync(RedisCommands.EVAL_NULL_BOOLEAN, (Long)permits);
    }

    @Override
    public void acquire() {
        this.get(this.acquireAsync());
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1L);
    }

    @Override
    public void acquire(long permits) {
        this.get(this.acquireAsync(permits));
    }

    @Override
    public RFuture<Void> acquireAsync(long permits) {
        CompletionStage<Void> f = this.tryAcquireAsync(permits, Duration.ofMillis(-1L)).thenApply(res -> null);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long timeout, TimeUnit unit) {
        return this.tryAcquireAsync(1L, timeout, unit);
    }

    @Override
    public boolean tryAcquire(Duration timeout) {
        return this.get(this.tryAcquireAsync(timeout));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(Duration timeout) {
        return this.tryAcquireAsync(1L, timeout);
    }

    @Override
    public boolean tryAcquire(long permits, Duration timeout) {
        return this.get(this.tryAcquireAsync(permits, timeout));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits, Duration timeout) {
        CompletableFuture<Boolean> f = this.tryAcquireAsync(permits, timeout.toMillis());
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public boolean tryAcquire(long permits, long timeout, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(permits, timeout, unit));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long permits, long timeout, TimeUnit unit) {
        return this.tryAcquireAsync(permits, Duration.ofMillis(unit.toMillis(timeout)));
    }

    private CompletableFuture<Boolean> tryAcquireAsync(long permits, long timeoutInMillis) {
        long s = System.currentTimeMillis();
        RFuture<Long> future = this.tryAcquireAsync(RedisCommands.EVAL_LONG, (Long)permits);
        return future.thenCompose(delay -> {
            if (delay == null) {
                return CompletableFuture.completedFuture(true);
            }
            if (timeoutInMillis == -1L) {
                CompletableFuture f = new CompletableFuture();
                this.getServiceManager().newTimeout(t -> {
                    CompletableFuture<Boolean> r = this.tryAcquireAsync(permits, timeoutInMillis);
                    this.commandExecutor.transfer(r, f);
                }, (long)delay, TimeUnit.MILLISECONDS);
                return f;
            }
            long el = System.currentTimeMillis() - s;
            long remains = timeoutInMillis - el;
            if (remains <= 0L) {
                return CompletableFuture.completedFuture(false);
            }
            CompletableFuture f = new CompletableFuture();
            if (remains < delay) {
                this.getServiceManager().newTimeout(t -> f.complete(false), remains, TimeUnit.MILLISECONDS);
            } else {
                long start = System.currentTimeMillis();
                this.getServiceManager().newTimeout(t -> {
                    long elapsed = System.currentTimeMillis() - start;
                    if (remains <= elapsed) {
                        f.complete(false);
                        return;
                    }
                    CompletableFuture<Boolean> r = this.tryAcquireAsync(permits, remains - elapsed);
                    this.commandExecutor.transfer(r, f);
                }, (long)delay, TimeUnit.MILLISECONDS);
            }
            return f;
        }).toCompletableFuture();
    }

    private <T> RFuture<T> tryAcquireAsync(RedisCommand<T> command, Long value) {
        byte[] random = this.getServiceManager().generateIdArray();
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, command, "local rate = redis.call('hget', KEYS[1], 'rate');local interval = redis.call('hget', KEYS[1], 'interval');local type = redis.call('hget', KEYS[1], 'type');assert(rate ~= false and interval ~= false and type ~= false, 'RateLimiter is not initialized')local valueName = KEYS[2];local permitsName = KEYS[4];if type == '1' then valueName = KEYS[3];permitsName = KEYS[5];end;assert(tonumber(rate) >= tonumber(ARGV[1]), 'Requested permits amount cannot exceed defined rate'); local currentValue = redis.call('get', valueName); local res;if currentValue ~= false then local expiredValues = redis.call('zrangebyscore', permitsName, 0, tonumber(ARGV[2]) - interval); local released = 0; for i, v in ipairs(expiredValues) do local random, permits = struct.unpack('Bc0I', v);released = released + permits;end; if released > 0 then redis.call('zremrangebyscore', permitsName, 0, tonumber(ARGV[2]) - interval); if tonumber(currentValue) + released > tonumber(rate) then local values = redis.call('zrange', permitsName, 0, -1); local used = 0; for i, v in ipairs(values) do local random, permits = struct.unpack('Bc0I', v);used = used + permits;end; currentValue = tonumber(rate) - used; else currentValue = tonumber(currentValue) + released; end; redis.call('set', valueName, currentValue);end;if tonumber(currentValue) < tonumber(ARGV[1]) then local firstValue = redis.call('zrange', permitsName, 0, 0, 'withscores'); res = 3 + interval - (tonumber(ARGV[2]) - tonumber(firstValue[2]));else redis.call('zadd', permitsName, ARGV[2], struct.pack('Bc0I', string.len(ARGV[3]), ARGV[3], ARGV[1])); redis.call('decrby', valueName, ARGV[1]); res = nil; end; else redis.call('set', valueName, rate); redis.call('zadd', permitsName, ARGV[2], struct.pack('Bc0I', string.len(ARGV[3]), ARGV[3], ARGV[1])); redis.call('decrby', valueName, ARGV[1]); res = nil; end;local keepAliveTime = redis.call('hget', KEYS[1], 'keepAliveTime'); if (keepAliveTime ~= false and tonumber(keepAliveTime) > 0) then redis.call('pexpire', KEYS[1], keepAliveTime); redis.call('pexpire', valueName, keepAliveTime); redis.call('pexpire', permitsName, keepAliveTime); else local ttl = redis.call('pttl', KEYS[1]); if ttl > 0 then redis.call('pexpire', valueName, ttl); redis.call('pexpire', permitsName, ttl); end; end; return res;", Arrays.asList(this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName()), value, System.currentTimeMillis(), random);
    }

    @Override
    public boolean trySetRate(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.get(this.trySetRateAsync(type, rate, rateInterval, unit));
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.trySetRateAsync(type, rate, Duration.ofMillis(unit.toMillis(rateInterval)), Duration.ZERO);
    }

    @Override
    public void setRate(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        this.get(this.setRateAsync(type, rate, rateInterval, unit));
    }

    @Override
    public RFuture<Void> setRateAsync(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.setRateAsync(type, rate, Duration.ofMillis(unit.toMillis(rateInterval)), Duration.ZERO);
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType type, long rate, Duration rateInterval, Duration keepAliveTime) {
        if (!keepAliveTime.equals(Duration.ZERO) && keepAliveTime.toMillis() < rateInterval.toMillis()) {
            throw new IllegalArgumentException("The parameter keepAliveTime should be greater than or equal to rateInterval");
        }
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], 'rate', ARGV[1]);redis.call('hsetnx', KEYS[1], 'interval', ARGV[2]);redis.call('hsetnx', KEYS[1], 'keepAliveTime', ARGV[4]);local res = redis.call('hsetnx', KEYS[1], 'type', ARGV[3]);if res == 1 and tonumber(ARGV[4]) > 0 then redis.call('pexpire', KEYS[1], ARGV[4]); end; return res;", Collections.singletonList(this.getRawName()), rate, rateInterval.toMillis(), type.ordinal(), keepAliveTime.toMillis());
    }

    @Override
    public boolean trySetRate(RateType mode, long rate, Duration rateInterval, Duration keepAliveTime) {
        return this.get(this.trySetRateAsync(mode, rate, rateInterval, keepAliveTime));
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType mode, long rate, Duration rateInterval) {
        return this.trySetRateAsync(mode, rate, rateInterval, Duration.ZERO);
    }

    @Override
    public boolean trySetRate(RateType mode, long rate, Duration rateInterval) {
        return this.get(this.trySetRateAsync(mode, rate, rateInterval));
    }

    @Override
    public void setRate(RateType mode, long rate, Duration rateInterval, Duration keepAliveTime) {
        this.get(this.setRateAsync(mode, rate, rateInterval, keepAliveTime));
    }

    @Override
    public RFuture<Void> setRateAsync(RateType type, long rate, Duration rateInterval, Duration keepAliveTime) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local valueName = KEYS[2];local permitsName = KEYS[4];if ARGV[3] == '1' then     valueName = KEYS[3];    permitsName = KEYS[5];end redis.call('hset', KEYS[1], 'rate', ARGV[1]);redis.call('hset', KEYS[1], 'interval', ARGV[2]);redis.call('hset', KEYS[1], 'type', ARGV[3]);redis.call('hset', KEYS[1], 'keepAliveTime', ARGV[4]);if tonumber(ARGV[4]) > 0 then redis.call('pexpire', KEYS[1], ARGV[4]); end; redis.call('del', valueName, permitsName);", Arrays.asList(this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName()), rate, rateInterval.toMillis(), type.ordinal(), keepAliveTime.toMillis());
    }

    @Override
    public void setRate(RateType mode, long rate, Duration rateInterval) {
        this.get(this.setRateAsync(mode, rate, rateInterval));
    }

    @Override
    public RFuture<Void> setRateAsync(RateType mode, long rate, Duration rateInterval) {
        return this.setRateAsync(mode, rate, rateInterval, Duration.ZERO);
    }

    @Override
    public RateLimiterConfig getConfig() {
        return this.get(this.getConfigAsync());
    }

    @Override
    public RFuture<RateLimiterConfig> getConfigAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, HGETALL, this.getRawName());
    }

    @Override
    public long availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Long> availablePermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local rate = redis.call('hget', KEYS[1], 'rate');local interval = redis.call('hget', KEYS[1], 'interval');local type = redis.call('hget', KEYS[1], 'type');assert(rate ~= false and interval ~= false and type ~= false, 'RateLimiter is not initialized')local valueName = KEYS[2];local permitsName = KEYS[4];if type == '1' then valueName = KEYS[3];permitsName = KEYS[5];end;local currentValue = redis.call('get', valueName); if currentValue == false then redis.call('set', valueName, rate); return rate; else local expiredValues = redis.call('zrangebyscore', permitsName, 0, tonumber(ARGV[1]) - interval); local released = 0; for i, v in ipairs(expiredValues) do local random, permits = struct.unpack('Bc0I', v);released = released + permits;end; if released > 0 then redis.call('zremrangebyscore', permitsName, 0, tonumber(ARGV[1]) - interval); currentValue = tonumber(currentValue) + released; redis.call('set', valueName, currentValue);end;return currentValue; end;", Arrays.asList(this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName()), System.currentTimeMillis());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getValueName(), this.getClientValueName(), this.getPermitsName(), this.getClientPermitsName());
    }
}

