/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.index;

import org.redisson.api.search.index.PhoneticMatcher;
import org.redisson.api.search.index.SortMode;
import org.redisson.api.search.index.TextIndex;

public final class TextIndexParams
implements TextIndex {
    private final String fieldName;
    private String as;
    private SortMode sortMode;
    private boolean noIndex;
    private boolean noStem;
    private PhoneticMatcher matcher;
    private boolean withSuffixTrie;
    private Double weight;
    private boolean indexEmpty;
    private boolean indexMissing;

    TextIndexParams(String name) {
        this.fieldName = name;
    }

    @Override
    public TextIndexParams as(String as) {
        this.as = as;
        return this;
    }

    @Override
    public TextIndexParams sortMode(SortMode sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    @Override
    public TextIndexParams noStem() {
        this.noStem = true;
        return this;
    }

    @Override
    public TextIndexParams noIndex() {
        this.noIndex = true;
        return this;
    }

    @Override
    public TextIndexParams withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public TextIndexParams phonetic(PhoneticMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    @Override
    public TextIndexParams weight(Double weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public TextIndexParams indexEmpty() {
        this.indexEmpty = true;
        return this;
    }

    @Override
    public TextIndexParams indexMissing() {
        this.indexMissing = true;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAs() {
        return this.as;
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public boolean isNoStem() {
        return this.noStem;
    }

    public PhoneticMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    public Double getWeight() {
        return this.weight;
    }

    public boolean isIndexEmpty() {
        return this.indexEmpty;
    }

    public boolean isIndexMissing() {
        return this.indexMissing;
    }
}

