/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonShutdownException;
import org.redisson.ScanResult;
import org.redisson.api.NodeType;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.FailedNodeDetector;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisReadonlyException;
import org.redisson.client.RedisReconnectedException;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.client.RedisRetryException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisWrongPasswordException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisExecutor<V, R> {
    static final Logger log = LoggerFactory.getLogger(RedisExecutor.class);
    final boolean readOnlyMode;
    final RedisCommand<V> command;
    final Object[] params;
    final CompletableFuture<R> mainPromise;
    final boolean ignoreRedirect;
    final RedissonObjectBuilder objectBuilder;
    final ConnectionManager connectionManager;
    final RedissonObjectBuilder.ReferenceType referenceType;
    final boolean noRetry;
    final int attempts;
    final int retryInterval;
    final int responseTimeout;
    final boolean trackChanges;
    CompletableFuture<RedisConnection> connectionFuture;
    boolean reuseConnection;
    NodeSource source;
    MasterSlaveEntry entry;
    Codec codec;
    volatile int attempt;
    volatile Optional<Timeout> timeout = Optional.empty();
    volatile BiConsumer<R, Throwable> mainPromiseListener;
    volatile ChannelFuture writeFuture;
    volatile RedisException exception;
    private static final Map<ClassLoader, Map<Codec, Codec>> CODECS = new LRUCacheMap<ClassLoader, Map<Codec, Codec>>(25, 0L, 0L);

    public RedisExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, CompletableFuture<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry, int retryAttempts, int retryInterval, int responseTimeout, boolean trackChanges) {
        this.readOnlyMode = readOnlyMode;
        this.source = source;
        this.codec = codec;
        this.command = command;
        this.params = params;
        this.mainPromise = mainPromise;
        this.ignoreRedirect = ignoreRedirect;
        this.connectionManager = connectionManager;
        this.objectBuilder = objectBuilder;
        this.noRetry = noRetry;
        this.attempts = retryAttempts;
        this.retryInterval = retryInterval;
        this.responseTimeout = responseTimeout;
        this.referenceType = referenceType;
        this.trackChanges = trackChanges;
    }

    public void execute() {
        if (this.mainPromise.isCancelled()) {
            this.free();
            return;
        }
        if (this.getClass() == RedisExecutor.class) {
            this.connectionManager.getServiceManager().addFuture(this.mainPromise);
        }
        if (this.connectionManager.getServiceManager().isShuttingDown()) {
            this.free();
            this.mainPromise.completeExceptionally(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        try {
            this.codec = this.getCodec(this.codec);
            CompletableFuture attemptPromise = new CompletableFuture();
            CompletableFuture<RedisConnection> connectionFuture = this.getConnection(attemptPromise);
            this.mainPromiseListener = (r, e) -> {
                if (!this.mainPromise.isCompletedExceptionally()) {
                    return;
                }
                if (connectionFuture.completeExceptionally(new CancellationException())) {
                    log.debug("Connection obtaining canceled for {}", (Object)this.command);
                    this.timeout.ifPresent(Timeout::cancel);
                    if (attemptPromise.completeExceptionally(new CancellationException())) {
                        this.free();
                    }
                    return;
                }
                if (this.command.isBlockingCommand()) {
                    if (this.writeFuture.cancel(false)) {
                        attemptPromise.completeExceptionally(new CancellationException());
                    } else {
                        RedisConnection c = connectionFuture.getNow(null);
                        c.forceFastReconnectAsync().whenComplete((res, ex) -> attemptPromise.completeExceptionally(new CancellationException()));
                    }
                }
            };
            if (this.attempt == 0) {
                this.mainPromise.whenComplete((r, e) -> {
                    if (this.mainPromiseListener != null) {
                        this.mainPromiseListener.accept((R)r, (Throwable)e);
                    }
                });
            }
            this.scheduleRetryTimeout(connectionFuture, attemptPromise);
            this.scheduleConnectionTimeout(attemptPromise, connectionFuture);
            connectionFuture.whenComplete((connection, e) -> {
                if (connectionFuture.isCancelled()) {
                    return;
                }
                if (this.connectionManager.getServiceManager().isShuttingDown()) {
                    this.exception = new RedissonShutdownException("Redisson is shutdown");
                    this.tryComplete(attemptPromise, this.exception);
                    return;
                }
                if (connectionFuture.isDone() && connectionFuture.isCompletedExceptionally()) {
                    this.exception = this.convertException(connectionFuture);
                    this.tryComplete(attemptPromise, this.exception);
                    return;
                }
                try {
                    this.sendCommand(attemptPromise, (RedisConnection)connection);
                }
                catch (Exception ex) {
                    this.free();
                    this.handleError(connectionFuture, (Throwable)e);
                    return;
                }
                this.scheduleWriteTimeout(attemptPromise);
                this.writeFuture.addListener(future -> this.checkWriteFuture(this.writeFuture, attemptPromise, (RedisConnection)connection));
            });
            ((CompletableFuture)attemptPromise.whenComplete((r, e) -> {
                this.releaseConnection(attemptPromise, connectionFuture);
                this.checkAttemptPromise(attemptPromise, connectionFuture);
            })).whenComplete((r, e) -> {
                if (e != null && !attemptPromise.isCompletedExceptionally()) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e2) {
            this.free();
            this.handleError(this.connectionFuture, e2);
            throw e2;
        }
    }

    private void scheduleConnectionTimeout(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) {
        if (this.retryInterval > 0 && this.attempts > 0) {
            return;
        }
        this.timeout.ifPresent(Timeout::cancel);
        TimerTask task = timeout -> {
            if (connectionFuture.completeExceptionally(new CancellationException())) {
                this.exception = new RedisTimeoutException("Unable to acquire connection! " + this.connectionFuture + "Increase connection pool size or timeout. Node source: " + this.source + ", " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts");
                attemptPromise.completeExceptionally(this.exception);
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(task, this.responseTimeout, TimeUnit.MILLISECONDS));
    }

    private void scheduleWriteTimeout(CompletableFuture<R> attemptPromise) {
        if (this.retryInterval > 0 && this.attempts > 0) {
            return;
        }
        this.timeout.ifPresent(Timeout::cancel);
        TimerTask task = timeout -> {
            if (this.writeFuture.cancel(false)) {
                this.exception = new RedisTimeoutException("Command still hasn't been written into connection! Check CPU usage of the JVM. Check that there are no blocking invocations in async/reactive/rx listeners or subscribeOnElements method. Check connection with Redis node: " + this.connectionFuture.join().getRedisClient().getAddr() + " for TCP packet drops. Try to increase nettyThreads setting.  Node source: " + this.source + ", connection: " + this.connectionFuture.join() + ", " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts");
                attemptPromise.completeExceptionally(this.exception);
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(task, this.responseTimeout, TimeUnit.MILLISECONDS));
    }

    private void scheduleRetryTimeout(final CompletableFuture<RedisConnection> connectionFuture, final CompletableFuture<R> attemptPromise) {
        if (this.retryInterval == 0 || this.attempts == 0) {
            return;
        }
        TimerTask retryTimerTask = new TimerTask(){

            @Override
            public void run(Timeout t) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.completeExceptionally(new CancellationException())) {
                    RedisExecutor.this.exception = new RedisTimeoutException("Unable to acquire connection! " + connectionFuture + "Increase connection pool size. Node source: " + RedisExecutor.this.source + ", " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                } else if (connectionFuture.isDone() && !connectionFuture.isCompletedExceptionally()) {
                    if (RedisExecutor.this.writeFuture == null || !RedisExecutor.this.writeFuture.isDone()) {
                        if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                            if (RedisExecutor.this.writeFuture != null && RedisExecutor.this.writeFuture.cancel(false)) {
                                if (RedisExecutor.this.exception == null) {
                                    RedisExecutor.this.exception = new RedisTimeoutException("Command still hasn't been written into connection! Check CPU usage of the JVM. Check that there are no blocking invocations in async/reactive/rx listeners or subscribeOnElements method. Check connection with Redis node: " + ((RedisConnection)RedisExecutor.this.getNow(connectionFuture)).getRedisClient().getAddr() + " for TCP packet drops. Try to increase nettyThreads setting.  Node source: " + RedisExecutor.this.source + ", connection: " + RedisExecutor.this.getNow(connectionFuture) + ", " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                                }
                                attemptPromise.completeExceptionally(RedisExecutor.this.exception);
                            }
                            return;
                        }
                        ++RedisExecutor.this.attempt;
                        RedisExecutor.this.scheduleRetryTimeout(connectionFuture, attemptPromise);
                        return;
                    }
                    if (RedisExecutor.this.writeFuture.isSuccess()) {
                        return;
                    }
                }
                if (RedisExecutor.this.mainPromise.isCompletedExceptionally()) {
                    Throwable c = RedisExecutor.this.cause(RedisExecutor.this.mainPromise);
                    if ((c instanceof CancellationException || c instanceof RedissonShutdownException) && attemptPromise.completeExceptionally(new CancellationException())) {
                        RedisExecutor.this.free();
                    }
                    return;
                }
                if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                    if (RedisExecutor.this.exception != null) {
                        attemptPromise.completeExceptionally(RedisExecutor.this.exception);
                    }
                    return;
                }
                if (!attemptPromise.completeExceptionally(new CancellationException())) {
                    return;
                }
                ++RedisExecutor.this.attempt;
                if (log.isDebugEnabled()) {
                    log.debug("attempt {} for {} to {}", RedisExecutor.this.attempt, LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params), RedisExecutor.this.source);
                }
                RedisExecutor.this.mainPromiseListener = null;
                RedisExecutor.this.execute();
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(retryTimerTask, this.retryInterval, TimeUnit.MILLISECONDS));
    }

    protected void free() {
        this.free(this.params);
    }

    protected void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease(obj);
        }
    }

    private void checkWriteFuture(ChannelFuture future, CompletableFuture<R> attemptPromise, RedisConnection connection) {
        if (future.isCancelled() || attemptPromise.isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            this.exception = new WriteRedisConnectionException("Unable to write command into connection! Check CPU usage of the JVM. Try to increase nettyThreads setting. Node source: " + this.source + ", connection: " + connection + ", " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts", future.cause());
            this.tryComplete(attemptPromise, this.exception);
            return;
        }
        this.scheduleResponseTimeout(attemptPromise, connection);
    }

    private void tryComplete(CompletableFuture<R> attemptPromise, RedisException exception) {
        if (this.attempt == this.attempts) {
            attemptPromise.completeExceptionally(exception);
        } else if (this.retryInterval == 0) {
            ++this.attempt;
            if (log.isDebugEnabled()) {
                log.debug("attempt {} for {} to {}", this.attempt, LogHelper.toString(this.command, this.params), this.source);
            }
            this.mainPromiseListener = null;
            this.execute();
        }
    }

    private void scheduleResponseTimeout(CompletableFuture<R> attemptPromise, RedisConnection connection) {
        this.timeout.ifPresent(Timeout::cancel);
        long timeoutTime = this.responseTimeout;
        if (this.command != null && this.command.isBlockingCommand()) {
            long popTimeout = 0L;
            if (RedisCommands.BLOCKING_COMMANDS.contains(this.command)) {
                for (int i = 0; i < this.params.length - 1; ++i) {
                    if (!"BLOCK".equals(this.params[i])) continue;
                    popTimeout = Long.valueOf(this.params[i + 1].toString());
                    break;
                }
            } else {
                popTimeout = RedisCommands.BZMPOP.getName().equals(this.command.getName()) ? Long.valueOf(this.params[0].toString()) * 1000L : Long.valueOf(this.params[this.params.length - 1].toString()) * 1000L;
            }
            this.handleBlockingOperations(attemptPromise, connection, popTimeout);
            if (popTimeout == 0L) {
                return;
            }
            timeoutTime += popTimeout;
            timeoutTime += 1000L;
        }
        long timeoutAmount = timeoutTime;
        TimerTask timeoutResponseTask = timeout -> {
            if (this.isResendAllowed(this.attempt, this.attempts)) {
                if (!attemptPromise.completeExceptionally(new CancellationException())) {
                    return;
                }
                this.connectionManager.getServiceManager().newTimeout(t -> {
                    ++this.attempt;
                    if (log.isDebugEnabled()) {
                        log.debug("response timeout. new attempt {} for {} node {}", this.attempt, LogHelper.toString(this.command, this.params), this.source);
                    }
                    this.mainPromiseListener = null;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            attemptPromise.completeExceptionally(new RedisResponseTimeoutException("Redis server response timeout (" + timeoutAmount + " ms) occured after " + this.attempt + " retry attempts, is non-idempotent command: " + (this.command != null && this.command.isNoRetry()) + " Check connection with Redis node: " + connection.getRedisClient().getAddr() + " for TCP packet drops or bandwidth limits.  Try to increase nettyThreads and/or timeout settings. " + LogHelper.toString(this.command, this.params) + ", channel: " + connection.getChannel()));
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(timeoutResponseTask, timeoutTime, TimeUnit.MILLISECONDS));
    }

    private boolean isResendAllowed(int attempt, int attempts) {
        return attempt < attempts && !this.noRetry && (this.command == null || !this.command.isBlockingCommand() && !this.command.isNoRetry());
    }

    private void handleBlockingOperations(CompletableFuture<R> attemptPromise, RedisConnection connection, long popTimeout) {
        Timeout scheduledFuture = popTimeout != 0L ? this.connectionManager.getServiceManager().newTimeout(timeout -> {
            List res = null;
            if (this.command.getReplayMultiDecoder() instanceof ObjectListReplayDecoder || this.command.getReplayMultiDecoder() instanceof ListMultiDecoder2) {
                res = Collections.emptyList();
            }
            if (attemptPromise.complete(res)) {
                connection.forceFastReconnectAsync();
            }
        }, popTimeout + 3000L, TimeUnit.MILLISECONDS) : null;
        this.mainPromise.whenComplete((res, e) -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel();
            }
            if ((this.mainPromise.isCancelled() || e instanceof InterruptedException) && !attemptPromise.isDone()) {
                log.debug("Canceled blocking operation {} used {}", (Object)this.command, (Object)connection);
                connection.forceFastReconnectAsync().whenComplete((r, ex) -> attemptPromise.completeExceptionally(new CancellationException()));
                return;
            }
            if (this.connectionManager.getServiceManager().isShuttingDown((Throwable)e)) {
                attemptPromise.completeExceptionally((Throwable)e);
            }
        });
    }

    protected final Throwable cause(CompletableFuture<?> future) {
        try {
            future.getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    protected void checkAttemptPromise(CompletableFuture<R> attemptFuture, CompletableFuture<RedisConnection> connectionFuture) {
        this.timeout.ifPresent(Timeout::cancel);
        if (attemptFuture.isCancelled()) {
            return;
        }
        try {
            ClientConnectionsEntry ce;
            RedisConnection connection;
            this.mainPromiseListener = null;
            Throwable cause = this.cause(attemptFuture);
            if (cause instanceof RedisWrongPasswordException && this.attempt < this.attempts) {
                this.onException();
                this.reuseConnection = true;
                CompletionStage<Void> f = connectionFuture.join().forceFastReconnectAsync();
                f.thenAccept(v -> {
                    ++this.attempt;
                    this.execute();
                });
                return;
            }
            if (cause instanceof RedisMovedException && !this.ignoreRedirect) {
                RedisMovedException ex = (RedisMovedException)cause;
                if (this.source.getRedirect() == NodeSource.Redirect.MOVED && this.source.getAddr().equals(ex.getUrl())) {
                    this.mainPromise.completeExceptionally(new RedisException("MOVED redirection loop detected. Node " + this.source.getAddr() + " has further redirect to " + ex.getUrl()));
                    return;
                }
                this.onException();
                CompletableFuture<RedisURI> ipAddrFuture = this.connectionManager.getServiceManager().resolveIP(ex.getUrl());
                ipAddrFuture.whenComplete((ip, e) -> {
                    if (e != null) {
                        this.free();
                        this.handleError(connectionFuture, (Throwable)e);
                        return;
                    }
                    this.source = new NodeSource(ex.getSlot(), (RedisURI)ip, NodeSource.Redirect.MOVED);
                    this.execute();
                });
                return;
            }
            if (cause instanceof RedisAskException && !this.ignoreRedirect) {
                RedisAskException ex = (RedisAskException)cause;
                this.onException();
                CompletableFuture<RedisURI> ipAddrFuture = this.connectionManager.getServiceManager().resolveIP(ex.getUrl());
                ipAddrFuture.whenComplete((ip, e) -> {
                    if (e != null) {
                        this.free();
                        this.handleError(connectionFuture, (Throwable)e);
                        return;
                    }
                    this.source = new NodeSource(ex.getSlot(), (RedisURI)ip, NodeSource.Redirect.ASK);
                    this.execute();
                });
                return;
            }
            if (cause instanceof RedisLoadingException && (connection = (RedisConnection)connectionFuture.getNow(null)) != null && (ce = this.entry.getEntry(connection.getRedisClient())) != null && ce.getNodeType() == NodeType.SLAVE) {
                this.source = new NodeSource(this.entry.getClient());
                this.execute();
                return;
            }
            if ((cause instanceof RedisRetryException || cause instanceof RedisReadonlyException || cause instanceof RedisReconnectedException && (this.writeFuture.cancel(false) || this.isResendAllowed(this.attempt, this.attempts))) && this.attempt < this.attempts) {
                this.onException();
                this.connectionManager.getServiceManager().newTimeout(timeout -> {
                    ++this.attempt;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            this.free();
            this.handleResult(attemptFuture, connectionFuture);
        }
        catch (Exception e2) {
            this.handleError(connectionFuture, e2);
        }
    }

    protected void handleResult(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) throws ReflectiveOperationException {
        R res;
        try {
            res = attemptPromise.getNow(null);
        }
        catch (CompletionException e) {
            this.handleError(connectionFuture, e.getCause());
            return;
        }
        catch (CancellationException e) {
            this.handleError(connectionFuture, e);
            return;
        }
        if (res instanceof ScanResult) {
            ((ScanResult)res).setRedisClient(this.getNow(connectionFuture).getRedisClient());
        }
        this.handleSuccess(this.mainPromise, connectionFuture, res);
    }

    protected void onException() {
    }

    protected void handleError(CompletableFuture<RedisConnection> connectionFuture, Throwable cause) {
        this.mainPromise.completeExceptionally(cause);
        if (connectionFuture == null) {
            return;
        }
        RedisClient client = connectionFuture.join().getRedisClient();
        FailedNodeDetector detector = client.getConfig().getFailedNodeDetector();
        detector.onCommandFailed(cause);
        if (detector.isNodeFailed()) {
            log.error("Redis node {} has been marked as failed as failed according to the detection logic defined in {}", (Object)this.entry.getClient().getAddr(), (Object)detector);
            this.entry.shutdownAndReconnectAsync(client, cause);
        }
    }

    protected void handleSuccess(CompletableFuture<R> promise, CompletableFuture<RedisConnection> connectionFuture, R res) throws ReflectiveOperationException {
        if (this.objectBuilder != null) {
            promise.complete(this.objectBuilder.tryHandleReference(res, this.referenceType));
        } else {
            promise.complete(res);
        }
        connectionFuture.join().getRedisClient().getConfig().getFailedNodeDetector().onCommandSuccessful();
    }

    protected void sendCommand(CompletableFuture<R> attemptPromise, RedisConnection connection) {
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            CompletableFuture promise = new CompletableFuture();
            list.add(new CommandData(promise, this.codec, RedisCommands.ASKING, new Object[0]));
            list.add(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
            CompletableFuture<Void> main = new CompletableFuture<Void>();
            this.writeFuture = connection.send(new CommandsData(main, list, false, false));
        } else {
            if (log.isDebugEnabled()) {
                String connectionType = " ";
                if (connection instanceof RedisPubSubConnection) {
                    connectionType = " pubsub ";
                }
                log.debug("acquired{}connection for {} from slot {} using node {}... {}", connectionType, LogHelper.toString(this.command, this.params), this.source, connection.getRedisClient().getAddr(), connection);
            }
            this.writeFuture = connection.send(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
            if (this.connectionManager.getServiceManager().getConfig().getMasterConnectionPoolSize() < 10 && !this.command.isBlockingCommand()) {
                this.release(connection);
            }
        }
    }

    protected void releaseConnection(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) {
        if (connectionFuture.isDone() && connectionFuture.isCompletedExceptionally()) {
            return;
        }
        Throwable cause = this.cause(attemptPromise);
        if (cause instanceof RedisWrongPasswordException && this.attempt < this.attempts) {
            return;
        }
        RedisConnection connection = this.getNow(connectionFuture);
        if (this.connectionManager.getServiceManager().getConfig().getMasterConnectionPoolSize() < 10) {
            if (this.source.getRedirect() == NodeSource.Redirect.ASK || this.getClass() != RedisExecutor.class || this.command != null && this.command.isBlockingCommand()) {
                this.release(connection);
            }
        } else {
            this.release(connection);
        }
        if (log.isDebugEnabled()) {
            String connectionType = " ";
            if (connection instanceof RedisPubSubConnection) {
                connectionType = " pubsub ";
            }
            log.debug("connection{}released for {} from slot {} using connection {}", connectionType, LogHelper.toString(this.command, this.params), this.source, connection);
        }
    }

    private void release(RedisConnection connection) {
        if (this.readOnlyMode) {
            this.entry.releaseRead(connection);
        } else {
            this.entry.releaseWrite(connection);
        }
    }

    public RedisClient getRedisClient() {
        return this.getNow(this.connectionFuture).getRedisClient();
    }

    protected CompletableFuture<RedisConnection> getConnection(CompletableFuture<R> attemptPromise) {
        if (this.reuseConnection) {
            this.reuseConnection = false;
            return this.connectionFuture;
        }
        this.connectionFuture = this.readOnlyMode ? this.connectionReadOp(this.command, attemptPromise) : this.connectionWriteOp(this.command, attemptPromise);
        return this.connectionFuture;
    }

    protected final Codec getCodec(Codec codec) {
        Map map;
        if (codec == null) {
            return null;
        }
        if (!this.connectionManager.getServiceManager().getCfg().isUseThreadClassLoader()) {
            return codec;
        }
        for (Class<?> clazz : BaseCodec.SKIPPED_CODECS) {
            if (!clazz.isAssignableFrom(codec.getClass())) continue;
            return codec;
        }
        Codec codecToUse = codec;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (codecToUse = (Codec)(map = CODECS.computeIfAbsent(threadClassLoader, k -> new LRUCacheMap(200, 0L, 0L))).get(codec)) == null) {
            try {
                codecToUse = (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(threadClassLoader, codec);
            }
            catch (NoSuchMethodException e) {
                codecToUse = codec;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            map.put(codec, codecToUse);
        }
        return codecToUse;
    }

    protected final <T> T getNow(CompletableFuture<T> future) {
        try {
            return future.getNow(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private <T> RedisException convertException(CompletableFuture<T> future) {
        Throwable cause = this.cause(future);
        if (cause instanceof RedisException) {
            return (RedisException)cause;
        }
        return new RedisException("Unexpected exception while processing command", cause);
    }

    final CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, CompletableFuture<R> attemptPromise) {
        try {
            this.entry = this.getEntry(true);
        }
        catch (Exception e) {
            attemptPromise.completeExceptionally(e);
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(e);
            return f;
        }
        if (this.entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException(this.source));
            return f;
        }
        if (this.source.getRedirect() != null) {
            return this.entry.connectionReadOp(command, this.source.getAddr());
        }
        if (this.source.getRedisClient() != null) {
            return this.entry.connectionReadOp(command, this.source.getRedisClient(), this.trackChanges);
        }
        return this.entry.connectionReadOp(command, this.trackChanges);
    }

    final CompletableFuture<RedisConnection> connectionWriteOp(RedisCommand<?> command, CompletableFuture<R> attemptPromise) {
        try {
            this.entry = this.getEntry(false);
        }
        catch (Exception e) {
            attemptPromise.completeExceptionally(e);
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(e);
            return f;
        }
        if (this.entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException(this.source));
            return f;
        }
        if (this.source.getRedirect() != null && !this.source.getAddr().equals(this.entry.getClient().getAddr()) && this.entry.hasSlave(this.source.getAddr())) {
            return this.entry.redirectedConnectionWriteOp(command, this.source.getAddr());
        }
        return this.entry.connectionWriteOp(command);
    }

    private MasterSlaveEntry getEntry(boolean read) {
        if (this.source.getRedirect() != null) {
            return this.connectionManager.getEntry(this.source.getAddr());
        }
        MasterSlaveEntry entry = this.source.getEntry();
        if (this.source.getRedisClient() != null) {
            entry = this.connectionManager.getEntry(this.source.getRedisClient());
        }
        if (entry == null && this.source.getSlot() != null) {
            entry = read ? this.connectionManager.getReadEntry(this.source.getSlot()) : this.connectionManager.getWriteEntry(this.source.getSlot());
        }
        return entry;
    }
}

