/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.SpinLock;

public class CommandsQueue
extends ChannelDuplexHandler {
    public static final AttributeKey<Deque<QueueCommandHolder>> COMMANDS_QUEUE = AttributeKey.valueOf("COMMANDS_QUEUE");
    private final SpinLock lock = new SpinLock();

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        ctx.channel().attr(COMMANDS_QUEUE).set(new ConcurrentLinkedDeque());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Queue queue = ctx.channel().attr(COMMANDS_QUEUE).get();
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            QueueCommandHolder command = (QueueCommandHolder)iterator.next();
            if (command.getCommand().isBlockingCommand()) continue;
            iterator.remove();
            command.getChannelPromise().tryFailure(new WriteRedisConnectionException("Channel has been closed! Can't write command: " + LogHelper.toString(command.getCommand()) + " to channel: " + ctx.channel()));
        }
        super.channelInactive(ctx);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof QueueCommand) {
            QueueCommand data = (QueueCommand)msg;
            QueueCommandHolder holder = new QueueCommandHolder(data, promise);
            Queue queue = ctx.channel().attr(COMMANDS_QUEUE).get();
            holder.getChannelPromise().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    queue.remove(holder);
                }
            }));
            this.lock.execute(() -> {
                try {
                    queue.add(holder);
                    ctx.writeAndFlush(data, holder.getChannelPromise());
                }
                catch (Exception e) {
                    queue.remove(holder);
                    throw e;
                }
            });
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

