/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.SlotCallback;
import org.redisson.api.RScript;
import org.redisson.api.RScriptReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;

public class RedissonScriptReactive
implements RScriptReactive {
    private final CommandReactiveExecutor commandExecutor;

    public RedissonScriptReactive(CommandReactiveExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Publisher<String> scriptLoad(String luaScript) {
        return this.commandExecutor.writeAllReactive(RedisCommands.SCRIPT_LOAD, new SlotCallback<String, String>(){
            volatile String result;

            @Override
            public void onSlotResult(String result) {
                this.result = result;
            }

            @Override
            public String onFinish() {
                return this.result;
            }
        }, luaScript);
    }

    public Publisher<String> scriptLoad(String key, String luaScript) {
        return this.commandExecutor.writeReactive(key, RedisCommands.SCRIPT_LOAD, luaScript);
    }

    @Override
    public <R> Publisher<R> eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.eval(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType, keys, values);
    }

    @Override
    public <R> Publisher<R> eval(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.eval(null, mode, codec, luaScript, returnType, keys, values);
    }

    public <R> Publisher<R> eval(String key, RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        if (mode == RScript.Mode.READ_ONLY) {
            return this.commandExecutor.evalReadReactive(key, codec, returnType.getCommand(), luaScript, keys, values);
        }
        return this.commandExecutor.evalWriteReactive(key, codec, returnType.getCommand(), luaScript, keys, values);
    }

    @Override
    public <R> Publisher<R> evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalSha(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, keys, values);
    }

    @Override
    public <R> Publisher<R> evalSha(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalSha(null, mode, codec, shaDigest, returnType, keys, values);
    }

    public <R> Publisher<R> evalSha(String key, RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        RedisCommand command = new RedisCommand(returnType.getCommand(), "EVALSHA");
        if (mode == RScript.Mode.READ_ONLY) {
            return this.commandExecutor.evalReadReactive(key, codec, command, shaDigest, keys, values);
        }
        return this.commandExecutor.evalWriteReactive(key, codec, command, shaDigest, keys, values);
    }

    @Override
    public Publisher<Void> scriptKill() {
        return this.commandExecutor.writeAllReactive(RedisCommands.SCRIPT_KILL, new Object[0]);
    }

    @Override
    public Publisher<List<Boolean>> scriptExists(final String ... shaDigests) {
        return this.commandExecutor.writeAllReactive(RedisCommands.SCRIPT_EXISTS, new SlotCallback<List<Boolean>, List<Boolean>>(){
            volatile List<Boolean> result;
            {
                this.result = new ArrayList<Boolean>(shaDigests.length);
            }

            @Override
            public synchronized void onSlotResult(List<Boolean> result) {
                for (int i = 0; i < result.size(); ++i) {
                    if (this.result.size() == i) {
                        this.result.add(false);
                    }
                    this.result.set(i, this.result.get(i) | result.get(i));
                }
            }

            @Override
            public List<Boolean> onFinish() {
                return new ArrayList<Boolean>(this.result);
            }
        }, (Object[])shaDigests);
    }

    public Publisher<List<Boolean>> scriptExists(String key, String ... shaDigests) {
        return this.commandExecutor.writeReactive(key, RedisCommands.SCRIPT_EXISTS, shaDigests);
    }

    @Override
    public Publisher<Void> scriptFlush() {
        return this.commandExecutor.writeAllReactive(RedisCommands.SCRIPT_FLUSH, new Object[0]);
    }

    @Override
    public <R> Publisher<R> evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> Publisher<R> evalSha(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(null, mode, codec, shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> Publisher<R> eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType) {
        return this.eval(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> Publisher<R> eval(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType) {
        return this.eval(null, mode, codec, luaScript, returnType, Collections.emptyList(), new Object[0]);
    }
}

