/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.api.RExpirableReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonObjectReactive;

abstract class RedissonExpirableReactive
extends RedissonObjectReactive
implements RExpirableReactive {
    RedissonExpirableReactive(CommandReactiveExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    RedissonExpirableReactive(Codec codec, CommandReactiveExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public Publisher<Boolean> expire(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, this.getName(), timeUnit.toMillis(timeToLive));
    }

    @Override
    public Publisher<Boolean> expireAt(long timestamp) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, this.getName(), timestamp);
    }

    @Override
    public Publisher<Boolean> expireAt(Date timestamp) {
        return this.expireAt(timestamp.getTime());
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, this.getName());
    }

    @Override
    public Publisher<Long> remainTimeToLive() {
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.PTTL, this.getName());
    }
}

