/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.BufferCodec;

public class JsonCodec<IN, OUT>
extends BufferCodec<IN, OUT> {
    private final Class<IN> inputType;
    private final ObjectMapper mapper;

    public JsonCodec(Class<IN> inputType) {
        this(inputType, null);
    }

    public JsonCodec(Class<IN> inputType, Module customModule) {
        this(inputType, customModule, (byte)0);
    }

    public JsonCodec(Class<IN> inputType, Module customModule, Byte delimiter) {
        super(delimiter);
        Assert.notNull(inputType, "inputType must not be null");
        this.inputType = inputType;
        this.mapper = new ObjectMapper();
        if (null != customModule) {
            this.mapper.registerModule(customModule);
        }
    }

    @Override
    protected IN doBufferDecode(Buffer buffer) {
        try {
            if (JsonNode.class.isAssignableFrom(this.inputType)) {
                return (IN)this.mapper.readTree(buffer.inputStream());
            }
            return this.mapper.readValue(buffer.inputStream(), this.inputType);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new JsonDecoder(next);
    }

    @Override
    public Buffer apply(OUT out) {
        try {
            return this.addDelimiterIfAny(new Buffer().append(this.mapper.writeValueAsBytes(out)));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private class JsonDecoder
    implements Function<Buffer, IN> {
        private final Consumer<IN> next;

        private JsonDecoder(Consumer<IN> next) {
            this.next = next;
        }

        @Override
        public IN apply(Buffer buffer) {
            return JsonCodec.this.doDelimitedBufferDecode(this.next, buffer);
        }
    }
}

