/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import reactor.fn.Function;
import reactor.rx.action.Action;

public class DistinctUntilChangedAction<T, V>
extends Action<T, T> {
    private V lastKey;
    private final Function<? super T, ? extends V> keySelector;

    public DistinctUntilChangedAction(Function<? super T, ? extends V> keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    protected void doNext(T currentData) {
        Object currentKey = this.keySelector != null ? this.keySelector.apply(currentData) : currentData;
        if (currentKey == null || !currentKey.equals(this.lastKey)) {
            this.lastKey = currentKey;
            this.broadcastNext(currentData);
        }
    }
}

