/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class GeoDistanceMapDecoder
implements MultiDecoder<Map<Object, Object>> {
    private final ThreadLocal<Integer> pos = new ThreadLocal();
    private final Codec codec;

    public GeoDistanceMapDecoder(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        if (this.pos.get() % 2 == 0) {
            return this.codec.getValueDecoder().decode(buf, state);
        }
        return DoubleCodec.INSTANCE.getValueDecoder().decode(buf, state);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        this.pos.set(paramNum);
        return true;
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }
}

