/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.Arrays;
import java.util.List;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.EmptyConvertor;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class RedisCommand<R> {
    private ValueType outParamType = ValueType.OBJECT;
    private List<ValueType> inParamType = Arrays.asList(ValueType.OBJECT);
    private final int inParamIndex;
    private final String name;
    private final String subName;
    private MultiDecoder<R> replayMultiDecoder;
    private Decoder<R> replayDecoder;
    Convertor<R> convertor = new EmptyConvertor();

    public RedisCommand(RedisCommand<R> command, String name) {
        this.outParamType = command.outParamType;
        this.inParamType = command.inParamType;
        this.inParamIndex = command.inParamIndex;
        this.name = name;
        this.subName = command.subName;
        this.replayMultiDecoder = command.replayMultiDecoder;
        this.replayDecoder = command.replayDecoder;
        this.convertor = command.convertor;
    }

    public RedisCommand(String name) {
        this(name, (String)null);
    }

    public RedisCommand(String name, ValueType outParamType) {
        this(name, (String)null);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, int objectParamIndex, ValueType inParamType) {
        this(name, null, null, null, objectParamIndex);
        this.inParamType = Arrays.asList(inParamType);
    }

    public RedisCommand(String name, ValueType inParamType, ValueType outParamType) {
        this(name, (String)null);
        this.inParamType = Arrays.asList(inParamType);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, String subName) {
        this(name, subName, null, null, -1);
    }

    public RedisCommand(String name, String subName, Convertor<R> convertor) {
        this(name, subName, null, null, -1);
        this.convertor = convertor;
    }

    public RedisCommand(String name, String subName, int objectParamIndex) {
        this(name, subName, null, null, objectParamIndex);
    }

    public RedisCommand(String name, int inParamIndex) {
        this(name, null, null, null, inParamIndex);
    }

    public RedisCommand(String name, Convertor<R> convertor, int inParamIndex, ValueType inParamType, ValueType outParamType) {
        this(name, null, null, null, inParamIndex);
        this.convertor = convertor;
        this.inParamType = Arrays.asList(inParamType);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, int inParamIndex, ValueType inParamType, ValueType outParamType) {
        this(name, null, null, null, inParamIndex);
        this.inParamType = Arrays.asList(inParamType);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, int inParamIndex, List<ValueType> inParamType, ValueType outParamType) {
        this(name, null, null, null, inParamIndex);
        this.inParamType = inParamType;
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder, int inParamIndex, List<ValueType> inParamType, ValueType outParamType) {
        this(name, null, null, reponseDecoder, inParamIndex);
        this.inParamType = inParamType;
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder, int inParamIndex, List<ValueType> inParamType) {
        this(name, null, null, reponseDecoder, inParamIndex);
        this.inParamType = inParamType;
    }

    public RedisCommand(String name, Convertor<R> convertor, int inParamIndex, ValueType inParamType) {
        this(name, null, null, null, inParamIndex);
        this.convertor = convertor;
        this.inParamType = Arrays.asList(inParamType);
    }

    public RedisCommand(String name, Convertor<R> convertor, int inParamIndex, List<ValueType> inParamTypes) {
        this(name, null, null, null, inParamIndex);
        this.convertor = convertor;
        this.inParamType = inParamTypes;
    }

    public RedisCommand(String name, Convertor<R> convertor) {
        this(name, convertor, -1);
    }

    public RedisCommand(String name, Convertor<R> convertor, int inParamIndex) {
        this(name, null, null, null, inParamIndex);
        this.convertor = convertor;
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder) {
        this(name, null, null, reponseDecoder, -1);
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder, int objectParamIndex, ValueType inParamType) {
        this(name, null, null, reponseDecoder, objectParamIndex);
        this.inParamType = Arrays.asList(inParamType);
    }

    public RedisCommand(String name, Decoder<R> reponseDecoder, int objectParamIndex) {
        this(name, null, null, reponseDecoder, objectParamIndex);
    }

    public RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder, ValueType outParamType) {
        this(name, subName, replayMultiDecoder, -1);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, ValueType outParamType) {
        this(name, replayMultiDecoder, -1);
        this.outParamType = outParamType;
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, int objectParamIndex, ValueType inParamType, ValueType outParamType) {
        this(name, replayMultiDecoder, objectParamIndex);
        this.outParamType = outParamType;
        this.inParamType = Arrays.asList(inParamType);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder) {
        this(name, replayMultiDecoder, -1);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, Convertor<R> convertor) {
        this(name, replayMultiDecoder, convertor, -1);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, Convertor<R> convertor, int inParamIndex) {
        this(name, replayMultiDecoder, inParamIndex);
        this.convertor = convertor;
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, int objectParamIndex, ValueType inParamType) {
        this(name, replayMultiDecoder, objectParamIndex, inParamType, null);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, int inParamIndex) {
        this(name, null, replayMultiDecoder, null, inParamIndex);
    }

    public RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder, int inParamIndex) {
        this(name, subName, replayMultiDecoder, null, inParamIndex);
    }

    public RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder, Decoder<R> reponseDecoder, int inParamIndex) {
        this.name = name;
        this.subName = subName;
        this.replayMultiDecoder = replayMultiDecoder;
        this.replayDecoder = reponseDecoder;
        this.inParamIndex = inParamIndex;
    }

    public String getSubName() {
        return this.subName;
    }

    public String getName() {
        return this.name;
    }

    public Decoder<R> getReplayDecoder() {
        return this.replayDecoder;
    }

    public int getInParamIndex() {
        return this.inParamIndex;
    }

    public MultiDecoder<R> getReplayMultiDecoder() {
        return this.replayMultiDecoder;
    }

    public Convertor<R> getConvertor() {
        return this.convertor;
    }

    public List<ValueType> getInParamType() {
        return this.inParamType;
    }

    public ValueType getOutParamType() {
        return this.outParamType;
    }

    public String toString() {
        return "(" + this.name + (this.subName != null ? " " + this.subName : "") + ")";
    }

    public static enum ValueType {
        OBJECT,
        OBJECTS,
        MAP_VALUE,
        MAP_KEY,
        MAP,
        BINARY,
        STRING;

    }
}

