/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.client.codec.Codec;
import org.redisson.cluster.ClusterConnectionManager;
import org.redisson.codec.CodecProvider;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ElasticacheServersConfig;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.ElasticacheConnectionManager;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.ReplicatedConnectionManager;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.connection.SingleConnectionManager;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.liveobject.provider.ResolverProvider;
import org.redisson.misc.URLBuilder;

public class ConfigSupport {
    private ObjectMapper jsonMapper = this.createMapper(null, null);
    private ObjectMapper yamlMapper = this.createMapper(new YAMLFactory(), null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromJSON(String content, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.jsonMapper.readValue(content, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    public <T> T fromJSON(File file, Class<T> configType) throws IOException {
        return this.fromJSON(file, configType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromJSON(File file, Class<T> configType, ClassLoader classLoader) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            this.jsonMapper = this.createMapper(null, classLoader);
            T t = this.jsonMapper.readValue(file, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromJSON(URL url, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.jsonMapper.readValue(url, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromJSON(Reader reader, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.jsonMapper.readValue(reader, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromJSON(InputStream inputStream, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.jsonMapper.readValue(inputStream, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    public String toJSON(Config config) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            String string = this.jsonMapper.writeValueAsString(config);
            return string;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(String content, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.yamlMapper.readValue(content, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(File file, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.yamlMapper.readValue(file, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(File file, Class<T> configType, ClassLoader classLoader) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            this.yamlMapper = this.createMapper(new YAMLFactory(), classLoader);
            T t = this.yamlMapper.readValue(file, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(URL url, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.yamlMapper.readValue(url, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(Reader reader, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.yamlMapper.readValue(reader, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromYAML(InputStream inputStream, Class<T> configType) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            T t = this.yamlMapper.readValue(inputStream, configType);
            return t;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    public String toYAML(Config config) throws IOException {
        URLBuilder.replaceURLFactory();
        try {
            String string = this.yamlMapper.writeValueAsString(config);
            return string;
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    public static ConnectionManager createConnectionManager(Config configCopy) {
        if (configCopy.getMasterSlaveServersConfig() != null) {
            ConfigSupport.validate(configCopy.getMasterSlaveServersConfig());
            return new MasterSlaveConnectionManager(configCopy.getMasterSlaveServersConfig(), configCopy);
        }
        if (configCopy.getSingleServerConfig() != null) {
            ConfigSupport.validate(configCopy.getSingleServerConfig());
            return new SingleConnectionManager(configCopy.getSingleServerConfig(), configCopy);
        }
        if (configCopy.getSentinelServersConfig() != null) {
            ConfigSupport.validate(configCopy.getSentinelServersConfig());
            return new SentinelConnectionManager(configCopy.getSentinelServersConfig(), configCopy);
        }
        if (configCopy.getClusterServersConfig() != null) {
            ConfigSupport.validate(configCopy.getClusterServersConfig());
            return new ClusterConnectionManager(configCopy.getClusterServersConfig(), configCopy);
        }
        if (configCopy.getElasticacheServersConfig() != null) {
            ConfigSupport.validate(configCopy.getElasticacheServersConfig());
            return new ElasticacheConnectionManager(configCopy.getElasticacheServersConfig(), configCopy);
        }
        if (configCopy.getReplicatedServersConfig() != null) {
            ConfigSupport.validate(configCopy.getReplicatedServersConfig());
            return new ReplicatedConnectionManager(configCopy.getReplicatedServersConfig(), configCopy);
        }
        if (configCopy.getConnectionManager() != null) {
            return configCopy.getConnectionManager();
        }
        throw new IllegalArgumentException("server(s) address(es) not defined!");
    }

    private static void validate(SingleServerConfig config) {
        if (config.getConnectionPoolSize() < config.getConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("connectionPoolSize can't be lower than connectionMinimumIdleSize");
        }
    }

    private static void validate(BaseMasterSlaveServersConfig<?> config) {
        if (config.getSlaveConnectionPoolSize() < config.getSlaveConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveConnectionPoolSize can't be lower than slaveConnectionMinimumIdleSize");
        }
        if (config.getMasterConnectionPoolSize() < config.getMasterConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("masterConnectionPoolSize can't be lower than masterConnectionMinimumIdleSize");
        }
        if (config.getSubscriptionConnectionPoolSize() < config.getSubscriptionConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveSubscriptionConnectionMinimumIdleSize can't be lower than slaveSubscriptionConnectionPoolSize");
        }
    }

    private ObjectMapper createMapper(JsonFactory mapping, ClassLoader classLoader) {
        ObjectMapper mapper = new ObjectMapper(mapping);
        mapper.addMixIn(MasterSlaveServersConfig.class, MasterSlaveServersConfigMixIn.class);
        mapper.addMixIn(SingleServerConfig.class, SingleSeverConfigMixIn.class);
        mapper.addMixIn(Config.class, ConfigMixIn.class);
        mapper.addMixIn(CodecProvider.class, ClassMixIn.class);
        mapper.addMixIn(ResolverProvider.class, ClassMixIn.class);
        mapper.addMixIn(Codec.class, ClassMixIn.class);
        mapper.addMixIn(RedissonNodeInitializer.class, ClassMixIn.class);
        mapper.addMixIn(LoadBalancer.class, ClassMixIn.class);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("classFilter", SimpleBeanPropertyFilter.filterOutAllExcept(new String[0]));
        mapper.setFilterProvider(filterProvider);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (classLoader != null) {
            TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
            mapper.setTypeFactory(tf);
        }
        return mapper;
    }

    @JsonIgnoreProperties(value={"clusterConfig"})
    public static class ConfigMixIn {
        @JsonProperty
        SentinelServersConfig sentinelServersConfig;
        @JsonProperty
        MasterSlaveServersConfig masterSlaveServersConfig;
        @JsonProperty
        SingleServerConfig singleServerConfig;
        @JsonProperty
        ClusterServersConfig clusterServersConfig;
        @JsonProperty
        ElasticacheServersConfig elasticacheServersConfig;
        @JsonProperty
        ReplicatedServersConfig replicatedServersConfig;
    }

    public static abstract class MasterSlaveServersConfigMixIn {
        @JsonProperty
        List<URI> masterAddress;

        @JsonIgnore
        abstract MasterSlaveServersConfig setMasterAddress(String var1);

        @JsonIgnore
        abstract URI getMasterAddress();

        @JsonIgnore
        abstract void setMasterAddress(URI var1);
    }

    public static abstract class SingleSeverConfigMixIn {
        @JsonProperty
        List<URI> address;

        @JsonIgnore
        abstract SingleServerConfig setAddress(String var1);

        @JsonIgnore
        abstract URI getAddress();

        @JsonIgnore
        abstract void setAddress(URI var1);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="class")
    @JsonFilter(value="classFilter")
    public static class ClassMixIn {
    }
}

