/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.OneShotPubSubListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;

public class RedisPubSubConnection
extends RedisConnection {
    final Queue<RedisPubSubListener<Object>> listeners = new ConcurrentLinkedQueue<RedisPubSubListener<Object>>();
    final Map<String, Codec> channels = PlatformDependent.newConcurrentHashMap();
    final Map<String, Codec> patternChannels = PlatformDependent.newConcurrentHashMap();
    final Set<String> unsubscibedChannels = new HashSet<String>();
    final Set<String> punsubscibedChannels = new HashSet<String>();

    public RedisPubSubConnection(RedisClient redisClient, Channel channel) {
        super(redisClient, channel);
    }

    public void addListener(RedisPubSubListener listener) {
        this.listeners.add(listener);
    }

    public void addOneShotListener(RedisPubSubListener listener) {
        this.listeners.add(new OneShotPubSubListener(this, listener));
    }

    public void removeListener(RedisPubSubListener<?> listener) {
        this.listeners.remove(listener);
    }

    public void onMessage(PubSubStatusMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onStatus(message.getType(), message.getChannel());
        }
    }

    public void onMessage(PubSubMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onMessage(message.getChannel(), message.getValue());
        }
    }

    public void onMessage(PubSubPatternMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onPatternMessage(message.getPattern(), message.getChannel(), message.getValue());
        }
    }

    public void subscribe(Codec codec, String ... channel) {
        for (String ch : channel) {
            this.channels.put(ch, codec);
        }
        this.async(new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SUBSCRIBE, (Object[])channel);
    }

    public void psubscribe(Codec codec, String ... channel) {
        for (String ch : channel) {
            this.patternChannels.put(ch, codec);
        }
        this.async(new PubSubPatternMessageDecoder(codec.getValueDecoder()), RedisCommands.PSUBSCRIBE, (Object[])channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(final String ... channels) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            for (String ch : channels) {
                this.channels.remove(ch);
                this.unsubscibedChannels.add(ch);
            }
        }
        ChannelFuture future = this.async((MultiDecoder<Object>)null, RedisCommands.UNSUBSCRIBE, (Object[])channels);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    for (String channel : channels) {
                        RedisPubSubConnection.this.removeDisconnectListener(channel);
                        RedisPubSubConnection.this.onMessage(new PubSubStatusMessage(PubSubType.UNSUBSCRIBE, channel));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisconnectListener(String channel) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            this.unsubscibedChannels.remove(channel);
            this.punsubscibedChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect() {
        HashSet<String> channels = new HashSet<String>();
        HashSet<String> pchannels = new HashSet<String>();
        Iterator iterator = this;
        synchronized (iterator) {
            channels.addAll(this.unsubscibedChannels);
            pchannels.addAll(this.punsubscibedChannels);
        }
        for (String channel : channels) {
            this.onMessage(new PubSubStatusMessage(PubSubType.UNSUBSCRIBE, channel));
        }
        for (String channel : pchannels) {
            this.onMessage(new PubSubStatusMessage(PubSubType.PUNSUBSCRIBE, channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punsubscribe(final String ... channels) {
        RedisPubSubConnection redisPubSubConnection = this;
        synchronized (redisPubSubConnection) {
            for (String ch : channels) {
                this.patternChannels.remove(ch);
                this.punsubscibedChannels.add(ch);
            }
        }
        ChannelFuture future = this.async((MultiDecoder<Object>)null, RedisCommands.PUNSUBSCRIBE, (Object[])channels);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    for (String channel : channels) {
                        RedisPubSubConnection.this.removeDisconnectListener(channel);
                        RedisPubSubConnection.this.onMessage(new PubSubStatusMessage(PubSubType.PUNSUBSCRIBE, channel));
                    }
                }
            }
        });
    }

    private <T, R> ChannelFuture async(MultiDecoder<Object> messageDecoder, RedisCommand<T> command, Object ... params) {
        return this.channel.writeAndFlush(new CommandData(null, messageDecoder, null, command, params));
    }

    public Map<String, Codec> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public Map<String, Codec> getPatternChannels() {
        return Collections.unmodifiableMap(this.patternChannels);
    }
}

