/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonScoredSortedSetReactive;

public class RedissonLexSortedSetReactive
extends RedissonScoredSortedSetReactive<String>
implements RLexSortedSetReactive {
    public RedissonLexSortedSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(StringCodec.INSTANCE, commandExecutor, name);
    }

    @Override
    public Publisher<Long> addAll(Publisher<? extends String> c) {
        return new PublisherAdder<String>(this).addAll(c);
    }

    @Override
    public Publisher<Integer> removeRangeHeadByLex(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public Publisher<Integer> removeRangeTailByLex(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public Publisher<Integer> removeRangeByLex(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Publisher<Collection<String>> lexRangeHead(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public Publisher<Collection<String>> lexRangeTail(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public Publisher<Collection<String>> lexRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Publisher<Collection<String>> lexRangeHead(String toElement, boolean toInclusive, int offset, int count) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue, "LIMIT", offset, count);
    }

    @Override
    public Publisher<Collection<String>> lexRangeTail(String fromElement, boolean fromInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+", "LIMIT", offset, count);
    }

    @Override
    public Publisher<Collection<String>> lexRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue, "LIMIT", offset, count);
    }

    @Override
    public Publisher<Integer> lexCountTail(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, "+");
    }

    @Override
    public Publisher<Integer> lexCountHead(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), "-", toValue);
    }

    @Override
    public Publisher<Integer> lexCount(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, toValue);
    }

    private String value(String fromElement, boolean fromInclusive) {
        String fromValue = fromElement.toString();
        fromValue = fromInclusive ? "[" + fromValue : "(" + fromValue;
        return fromValue;
    }

    @Override
    public Publisher<Long> add(String e) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_RAW, this.getName(), 0, e);
    }

    @Override
    public Publisher<Long> addAll(Collection<? extends String> c) {
        ArrayList<Object> params = new ArrayList<Object>(2 * c.size());
        for (String string : c) {
            params.add(0);
            params.add(string);
        }
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_RAW, this.getName(), params.toArray());
    }
}

